#!/usr/bin/perl -w
#
# by Netexpertise
# http://www.netexpertise.eu
#
#

require "./conf.pl";
use DBI;
use GD::Graph::bars;
use HTTP::Date;
use strict;

my( $username, $sourceip, $dbi_dsn );
use vars qw($dbtype $raddb $radhost $period $username $raduser $radpass);
my %FORM;

### Main

# Load parameters
$dbi_dsn='dbi:'.$dbtype.':'.$raddb.';'.$radhost;

&get_username_form();

if ( !$FORM{'username'} ) {
  # Retrieve customer's IP address
  $sourceip = $ENV{'REMOTE_ADDR'};
  $username = get_username($sourceip);
} else {
  $username = $FORM{'username'};
}

my $data=get_data($username);
&gen_graph($data);

### End Main


#
#
## Get username
sub get_username_form (){
  my ( $FormData, $pair, $name, $value );

  # Read the standard input (sent by the form):
  $FormData = $ENV{'QUERY_STRING'};
  # Get the name and value for each form input:
  my @pairs = split(/&/, $FormData);
  # Then for each name/value pair....
  foreach $pair (@pairs) {
    # Separate the name and value:
    ($name, $value) = split(/=/, $pair);
    # Convert + signs to spaces:
    $value =~ tr/+/ /;
    # Convert hex pairs (%HH) to ASCII characters:
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    # Store values in a hash called %FORM:
    $FORM{$name} = $value;
  }
}


#
#
## Retrieve username in Radius based on IP address
sub get_username {

  my $sourceip = shift or die;
  my ( $username, $sqlquery );
  my $dbh=DBI->connect($dbi_dsn, $raduser, $radpass,);

  if ( !$dbh ) {
    print "Could not connect to database: $DBI::errstr\n";
    return;
  }

  $sqlquery=" \
  SELECT Username \
  FROM radacct \
  WHERE FramedIPAddress = \'$sourceip\' \
  ORDER BY Acctstarttime \
  DESC LIMIT 1;";

  my $sth = $dbh->prepare($sqlquery);
  $sth->execute();

  $sth->bind_columns( \$username);
  $sth->fetch();
  $sth->finish();
  $dbh->disconnect();
  return $username;
}


#
#
## Retrieve customer's traffic for the last period
sub get_data {

  my $l_username = shift;
  my ( $day, $download, $upload, $startdate, $isostartdate, $sqlquery ) = ('?', '?', '?', '?', '?', '?');
  my ( @l_data, @days, @downloads, @uploads );
  my $dbh=DBI->connect($dbi_dsn, $raduser, $radpass,);

  if ( !$dbh ) {
    print "Could not connect to database: $DBI::errstr\n";
    return;
  }

  my ($curdate) = int((str2time(HTTP::Date::time2iso()))/86400);
  $startdate = $curdate - $period;
  ($isostartdate, ) = split(" ", HTTP::Date::time2iso($startdate*86400));

  $sqlquery = " \
  SELECT DATE(Acctstoptime) AS DayOfTheMonth, \
  SUM(AcctOutputOctets) AS Download, \
  SUM(AcctInputOctets) AS Upload FROM radacct \
  WHERE (DATE(Acctstoptime) BETWEEN \'$isostartdate\' AND CURRENT_DATE) \
  AND username=\'$l_username\'
  GROUP BY DayOfTheMonth \
  ORDER BY DayOfTheMonth;";

  my $sth = $dbh->prepare($sqlquery);
  $sth->execute();
  $sth->bind_columns( \$day, \$download, \$upload );

  foreach my $i (0..($period)){
    my ($date) = $curdate - ($period-$i);
    my ($idate) = split(" ", HTTP::Date::time2iso($date*86400));
    my ($y,$m,$d) = split("-", $idate);
    push( @days, $d);
    push( @downloads, 0);
    push( @uploads, 0);
  }

  while ( $sth->fetch() ) {
    my $id=(int(str2time($day)/86400))-$startdate+1;
    $downloads[$id] = int($download/1024/1024);
    $uploads[$id] = int($upload/1024/1024);
  }

  push @l_data,  [ @days ] , [ @downloads ], [ @uploads ];

  $sth->finish();
  $dbh->disconnect();

  return \@l_data;
}


#
#
## Generate Graph
sub gen_graph (){
  
  my $l_data = shift;

  my $graph = GD::Graph::bars->new(760, 400);
    
  $graph->set(
	      x_label          => 'Date',
	      y_label          => 'Usage (MB)',
	      title            => 'Traffic Usage for the Month    ',
              bar_spacing      => 3,
              overwrite        => 1,
              cumulate         => 1,
              transparent      => 1,
              dclrs            => [qw( lblue purple)],
              box_axis         => 0,
              x_label_position => 1,
	      y_min_value      => 0,
	     ) or warn $graph->error;

  $graph->set_title_font(GD::gdGiantFont, 24);
  $graph->set_legend_font(GD::gdMediumBoldFont);
  $graph->set_legend('Download', 'Upload');
  $graph->set_x_label_font(GD::gdMediumBoldFont);
  $graph->set_y_label_font(GD::gdMediumBoldFont);

  my $image = $graph->plot(\@$l_data) or die $graph->error;

  print "Content-type: image/png\n\n";
  print $image->png;

}
