'
' Copyright (c) Microsoft Corporation.  All rights reserved.
'
' VBScript Source File
'
' Script Name: IIsExt.vbs
'

Option Explicit
On Error Resume Next

' Error codes
Const ERR_OK              = 0
Const ERR_GENERAL_FAILURE = 1

'''''''''''''''''''''
' Messages
Const L_NotEnoughParams_ErrorMessage   = "Paramtres insuffisants."
Const L_InvalidSwitch_ErrorMessage     = "Commutateur non valide : %1"
Const L_CmdLib_ErrorMessage            = "Impossible de crer une instance de l'objet CmdLib."
Const L_ChkCmdLibReg_ErrorMessage      = "Veuillez enregistrer le composant Microsoft.CmdLib."
Const L_ScriptHelper_ErrorMessage      = "Impossible de crer une instance de l'objet IIsScriptHelper."
Const L_ChkScpHelperReg_ErrorMessage   = "Vrifiez si Microsoft.IIsScriptHelper est enregistr."
Const L_OnlyOneOper_ErrorMessage       = "Spcifier une opration en un temps donn."
Const L_PassWithoutUser_ErrorMessage   = "Spcifier le commutateur /u avant /p."
Const L_WMIConnect_ErrorMessage        = "Impossible de se connecter au fournisseur WMI."
Const L_Error_ErrorMessage             = "Erreur &H%1 : %2"
Const L_Admin_ErrorMessage             = "Vous ne pouvez pas excuter cette commande car vous n'tes pas"
Const L_Adminp2_ErrorMessage           = "un administrateur sur le serveur que vous essayez de configurer."
Const L_GetWebSvcObj_ErrorMessage      = "Impossible d'obtenir l'objet du service Web"
Const L_EnApp_ErrorMessage             = "Erreur lors de la configuration de l'application ou de l'extension."
Const L_NoApp_ErrorMessage             = "L'application spcifie n'existe pas dans la liste de dpendances"
Const L_NoAppp2_ErrorMessage           = "des applications."
Const L_NoDep_ErrorMessage             = "La relation application-extension spcifie n'existe pas"
Const L_NoDepp2_ErrorMessage           = "dans la liste de dpendances des applications."
Const L_NoExt_ErrorMessage             = "L'extension n'existe pas dans la liste de restrictions."
Const L_NoEfi_ErrorMessage             = "Le fichier d'extension n'existe pas dans la liste de restrictions."

Const L_EnDep_ErrorMessage             = "Erreur lors de la configuration des dpendances."
Const L_ShowList_ErrorMessage          = "Erreur lors de l'affichage de la liste. Confirmez que les proprits"
Const L_ShowList2_ErrorMessage         = "WebSvcExtRestrictionList et ApplicationDependencies"
Const L_ShowList3_ErrorMessage         = "existent et sont configures sur le nud W3SVC."
Const L_RmEfi_ErrorMessage             = "Une erreur s'est produite lors de la tentative de suppression de"
Const L_RmEfip2_ErrorMessage           = "l'extension. Assurez-vous qu'elle existe et peut tre supprime."
Const L_EnAppComplete_Message          = "Fin de l'activation de l'application."
Const L_AddDpComplete_Message          = "Fin de l'ajout de la dpendance."
Const L_RemDpComplete_Message          = "Fin de la suppression de la dpendance."
Const L_EnExtComplete_Message          = "Fin de l'activation de l'extension."
Const L_DsExtComplete_Message          = "Fin de la dsactivation de l'extension."
Const L_DsEFiComplete_Message          = "Fin de la dsactivation du fichier d'extension."
Const L_EnEFiComplete_Message          = "Fin de l'activation du fichier d'extension."
Const L_AdEFiComplete_Message          = "Fin de l'ajout du fichier d'extension."
Const L_RmEFiComplete_Message          = "Fin de la suppression du fichier d'extension."
Const L_ShowListFile_Message           = "Statut / Chemin de l'extension"
Const L_ShowListFile2_Message          = "-------------------------------"
'''''''''''''''''''''
' Help
Const L_Empty_Text     = ""

' General help messages
Const L_SeeHelp_Message         = "Entrez IIsExt /? pour afficher l'aide."
 
Const L_Help_HELP_General01_Text  = "Description: gre les extensions du service Web."
Const L_Help_HELP_General02_Text  = "Syntaxe: IIsExt [/s <serveur> [/u <nom_utilisateur> [/p <mot_de_passe>]]]"
Const L_Help_HELP_General02a_Text = "                   [/ListExt | /ListApp | /AddDep | /DisExt"
Const L_Help_HELP_General03_Text  = "                    /EnExt | /RmDep | /EnApp | /EnFile | /DisFile"
Const L_Help_HELP_General04_Text  = "                    /AddFile | /ListFile | /RmFile] <args>"
Const L_Help_HELP_General05_Text  = "Commutateurs :"
Const L_Help_HELP_General06_Text  = "Valeur                  Description"
Const L_Help_HELP_General06a_Text = "/s <serveur>            Connecter  l'ordinateur <serveur>."
Const L_Help_HELP_General06b_Text = "                        [Par dfaut: ce systme]"
Const L_Help_HELP_General06c_Text = "/u <nom_utilisateur>    Connecter en tant que <domaine>\<nom_utilisateur> ou"
Const L_Help_HELP_General06d_Text = "                        <nom_utilisateur>. [Par dfaut: utilisateur actuel]"
Const L_Help_HELP_General06e_Text = "/p <mot_passe>          Mot de passe pour l'utilisateur <nom_utilisateur>."
Const L_Help_HELP_General07_Text  = "/EnApp <nomapp>         Active une application dans la liste"
Const L_Help_HELP_General07a_Text = "                        de dpendance des applications."
Const L_Help_HELP_General08_Text  = "/ListApp                Liste les applications dans la"
Const L_Help_HELP_General08a_Text = "                        liste de dpendance des applications."
Const L_Help_HELP_General09_Text  = "/AddDep <nomapp> <ID> [<ID> ...]" 
Const L_Help_HELP_General09a_Text = "                        Ajoute une dpendance entre une"
Const L_Help_HELP_General09b_Text = "                        application dans la liste de dpendances"
Const L_Help_HELP_General09c_Text = "                        des applications et l'ID d'extension"
Const L_Help_HELP_General09d_Text = "                        du service Web."
Const L_Help_HELP_General10_Text  = "/RmDep  <nomapp> <ID> [<ID> ...]"
Const L_Help_HELP_General10a_Text = "                        Supprime une dpendance entre une"
Const L_Help_HELP_General10b_Text = "                        application dans la liste des dpendances"
Const L_Help_HELP_General10c_Text = "                        des applications et l'ID d'extension"
Const L_Help_HELP_General10d_Text = "                        du service Web."
Const L_Help_HELP_General11_Text  = "/EnExt <ID>             Active tous les fichiers pour une extension"
Const L_Help_HELP_General11a_Text = "                        du service Web avec l'ID d'extension"
Const L_Help_HELP_General11b_Text = "                        du service Web spcifi."
Const L_Help_HELP_General12_Text  = "/DisExt <ID>            Dsactive tous les fichiers pour l'extension"
Const L_Help_HELP_General12a_Text = "                        du service Web avec l'ID d'extension"
Const L_Help_HELP_General12b_Text = "                        du service Web spcifi."
Const L_Help_HELP_General13_Text  = "/ListExt                Liste tous les ID d'extension du service Web pour"
Const L_Help_HELP_General13a_Text = "                        toutes les extensions du service Web dfinies."
Const L_Help_HELP_General14_Text  = "/EnFile <nom_fichier>   Active un seul fichier dans la"
Const L_Help_HELP_General14a_Text = "                        liste de restrictions."
Const L_Help_HELP_General15_Text  = "/DisFile <nom_fichier>  Dsactive un seul fichier dans la"
Const L_Help_HELP_General15a_Text = "                        liste de restrictions."
Const L_Help_HELP_General16_Text  = "/ListFile               Liste tous les fichiers dans la"
Const L_Help_HELP_General16a_Text = "                        liste de restrictions."
Const L_Help_HELP_General17_Text  = "/RmFile <nom_fichier>   Supprime un fichier de la liste"
Const L_Help_HELP_General17a_Text = "                        de restrictions s'il peut tre supprim."
Const L_Help_HELP_General18_Text  = "/AddFile <args>         Ajoute un fichier  la liste de restrictions."
Const L_Help_HELP_General19_Text  = "/AddFile /?             Affiche l'aide pour l'indicateur /AddFile."

Const L_Help_HELP_AddFile01_Text  = "Description: ajoute un fichier  la liste de restrictions."
Const L_Help_HELP_AddFile02_Text  = "Syntaxe: IIsExt [/s <serveur> [/u <nom_utilisateur> [/p <mot_de_passe>]]]"
Const L_Help_HELP_AddFile02a_Text = "               /AddFile <chemin_fichier> <accs> <ID> <supprim>"
Const L_Help_HELP_AddFile03_Text  = "               <BrveDesc>"
Const L_Help_HELP_AddFile07_Text  = "<chemin_fichier>        Le chemin d'accs pleinement qualifi  la dll"
Const L_Help_HELP_AddFile08_Text  = "                        ou  l'exe, incluant le nom de fichier et" 
Const L_Help_HELP_AddFile09_Text  = "                        l'extension. La casse spciale inclut"
Const L_Help_HELP_AddFile09a_Text = "                        *.dll pour activer/dsactiver les ISAPI"
Const L_Help_HELP_AddFile09b_Text = "                        non lists et les *.exe pour activer/dsactiver"
Const L_Help_HELP_AddFile09c_Text = "                        les CGI non lists."
Const L_Help_HELP_AddFile10_Text  = "<access>                Dfinir cette valeur  0 pour dsactiver ou 1 pour"
Const L_Help_HELP_AddFile10a_Text = "                        activer le fichier aprs son ajout."
Const L_Help_HELP_AddFile11_Text  = "<ID>                    Cet ID est un identificateur arbitraire"
Const L_Help_HELP_AddFile11a_Text = "                        qui identifie l'Extension du Service Web"
Const L_Help_HELP_AddFile11b_Text = "                        auquel le fichier est associ."
Const L_Help_HELP_AddFile12_Text  = "                        IL peut y avoir un ou plusieurs fichiers pour"
Const L_Help_HELP_AddFile12a_Text = "                        chaque extension de service Web"
Const L_Help_HELP_AddFile13_Text  = "<deletable>             Dfinir cette valeur  0 pour empcher ce fichier"
Const L_Help_HELP_AddFile13a_Text = "                        d'tre supprim de la liste" 
Const L_Help_HELP_AddFile14_Text  = "                        de restrictions ou 1 pour autoriser la suppression de ce"
Const L_Help_HELP_AddFile14a_Text = "                        fichier de la liste de restrictions."
Const L_Help_HELP_AddFile15_Text  = "<ShortDesc>             C'est une brve description texte de"
Const L_Help_HELP_AddFile15a_Text = "                        de l'extension du service Web auquel le fichier est"
Const L_Help_HELP_AddFile16_Text  = "                        associ. Les fichiers avec le mme"
Const L_Help_HELP_AddFile16a_Text = "                        ID devrait avoir la mme brve description."

''''''''''''''''''''''''
' Operation codes
Const OPER_ENAPP = 1
Const OPER_ADDDP = 3
Const OPER_REMDP = 4
Const OPER_ENEXT = 5
Const OPER_DSEXT = 6
Const OPER_ENEFI = 7
Const OPER_DSEFI = 8
Const OPER_ADEFI = 9
Const OPER_RMEFI = 10
Const OPER_LSAPP = 11
Const OPER_LSEXT = 12
Const OPER_LSEFI = 13

'
' Main block
'
Dim oScriptHelper, oCmdLib
Dim intResult, intOperation
Dim strServer, strUser, strPassword
Dim strCmdLineOptions, strAppName
Dim oError, aArgs

' Default values
strServer = "."
strUser = ""
strPassword = ""
intOperation = 0

' Instantiate the CmdLib for output string formatting
Set oCmdLib = CreateObject("Microsoft.CmdLib")
If Err.Number <> 0 Then
    WScript.Echo L_CmdLib_ErrorMessage
    WScript.Echo L_ChkCmdLibReg_ErrorMessage    
    WScript.Quit(ERR_GENERAL_FAILURE)
End If
Set oCmdLib.ScriptingHost = WScript.Application

' Instantiate script helper object
Set oScriptHelper = CreateObject("Microsoft.IIsScriptHelper")
If Err.Number <> 0 Then
    WScript.Echo L_ScriptHelper_ErrorMessage
    WScript.Echo L_ChkScpHelperReg_ErrorMessage    
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

Set oScriptHelper.ScriptHost = WScript

' Check if we are being run with cscript.exe instead of wscript.exe
oScriptHelper.CheckScriptEngine

' Command Line parsing
Dim argObj, arg
Set argObj = WScript.Arguments

strCmdLineOptions = "[server:s:1;user:u:1;password:p:1];enapp::1;listapp::0;adddep::n;" &_
                    "rmdep::n;enext::1;disext::n;listext::0;enfile::1;disfile::1;addfile::5;" &_
                    "rmfile::1;listfile::0"

Set oError = oScriptHelper.ParseCmdLineOptions(strCmdLineOptions)

If Not oError Is Nothing Then
    If oError.ErrorCode = oScriptHelper.ERROR_NOT_ENOUGH_ARGS Then
        ' Not enough arguments for a specified switch
        WScript.Echo L_NotEnoughParams_ErrorMessage
        WScript.Echo L_SeeHelp_Message
    Else
        ' Invalid switch
        oCmdLib.vbPrintf L_InvalidSwitch_ErrorMessage, Array(oError.SwitchName)
      	WScript.Echo L_SeeHelp_Message
    End If
    
        WScript.Quit(ERR_GENERAL_FAILURE)
End If

If oScriptHelper.GlobalHelpRequested Then
    DisplayHelpMessage
    WScript.Quit(ERR_OK)
End If

For Each arg In oScriptHelper.Switches
    Select Case arg

    Case "server"
        ' Server information
        strServer = oScriptHelper.GetSwitch(arg)

    Case "user"
        ' User information
        strUser = oScriptHelper.GetSwitch(arg)

    Case "password"
        ' Password information
        strPassword = oScriptHelper.GetSwitch(arg)

    Case "enapp"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_ENAPP

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

        strAppName = oScriptHelper.GetSwitch(arg)

    Case "adddep"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_ADDDP

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

        aArgs = oScriptHelper.GetSwitch(arg)

        If UBound(aArgs) = -1 Then
            WScript.Echo L_NotEnoughParams_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

    Case "rmdep"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_REMDP

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

        aArgs = oScriptHelper.GetSwitch(arg)

        If UBound(aArgs) = -1 Then
            WScript.Echo L_NotEnoughParams_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

    Case "enext"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_ENEXT

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

        strAppName = oScriptHelper.GetSwitch(arg)

    Case "disfile"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_DSEFI

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

        strAppName = oScriptHelper.GetSwitch(arg)

    Case "enfile"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_ENEFI

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

        strAppName = oScriptHelper.GetSwitch(arg)

    Case "disext"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_DSEXT

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

        aArgs = oScriptHelper.GetSwitch(arg)

    Case "addfile"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_ADEFI

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display addfile specific help
            DisplayAddFileHelp
            WScript.Quit(ERR_OK)
        End If

        aArgs = oScriptHelper.GetSwitch(arg)

    Case "rmfile"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_RMEFI

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

        strAppName = oScriptHelper.GetSwitch(arg)

    Case "listapp"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_LSAPP

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

    Case "listext"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_LSEXT

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

    Case "listfile"
        If (intOperation <> 0) Then
            WScript.Echo L_OnlyOneOper_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If

        intOperation = OPER_LSEFI

        If oScriptHelper.IsHelpRequested(arg) Then
            ' display enapp specific help
        End If

    End Select
Next

' Check Parameters
If intOperation = 0 Then
    WScript.Echo L_SeeHelp_Message
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

' Check if /p is specified but /u isn't. In this case, we should bail out with an error
If oScriptHelper.Switches.Exists("password") And Not oScriptHelper.Switches.Exists("user") Then
    WScript.Echo L_PassWithoutUser_ErrorMessage
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

' Check if /u is specified but /p isn't. In this case, we should ask for a password
If oScriptHelper.Switches.Exists("user") And Not oScriptHelper.Switches.Exists("password") Then
    strPassword = oCmdLib.GetPassword
End If

' Initializes authentication with remote machine
intResult = oScriptHelper.InitAuthentication(strServer, strUser, strPassword)
If intResult <> 0 Then
    WScript.Quit(intResult)
End If

' Choose operation
Select Case intOperation
	Case OPER_ENAPP
		intResult = ChApp(strAppName, intOperation)
        If intResult=0 Then
            WScript.Echo(L_EnAppComplete_Message)
        End If

    Case OPER_ADDDP
        intResult = ChDep(aArgs, intOperation)
        If intResult=0 Then
            WScript.Echo(L_AddDpComplete_Message)
        End If

    Case OPER_REMDP
        intResult = ChDep(aArgs, intOperation)
        If intResult=0 Then
            WScript.Echo(L_RemDpComplete_Message)
        End If

	Case OPER_ENEXT
		intResult = ChApp(strAppName, intOperation)
        If intResult=0 Then
            WScript.Echo(L_EnExtComplete_Message)
        End If

	Case OPER_ENEFI
		intResult = ChApp(strAppName, intOperation)
        If intResult=0 Then
            WScript.Echo(L_EnEfiComplete_Message)
        End If

	Case OPER_DSEFI
		intResult = ChApp(strAppName, intOperation)
        If intResult=0 Then
            WScript.Echo(L_DsEfiComplete_Message)
        End If

	Case OPER_DSEXT
		intResult = DsExt(aArgs)
        If intResult=0 Then
            WScript.Echo(L_DsExtComplete_Message)
        End If

	Case OPER_ADEFI
		intResult = ChDep(aArgs, intOperation)
        If intResult=0 Then
            WScript.Echo(L_AdEFiComplete_Message)
        End If

	Case OPER_RMEFI
		intResult = RmEfi(strAppName)
        If intResult=0 Then
            WScript.Echo(L_RmEFiComplete_Message)
        End If

	Case OPER_LSAPP
		intResult = ShowList(intOperation)
    
	Case OPER_LSEXT
		intResult = ShowList(intOperation)
	
	Case OPER_LSEFI
		intResult = ShowListFile()

End Select

' Return value to command processor
WScript.Quit(intResult)

'''''''''''''''''''''''''
' End Of Main Block
'''''''''''''''''''''

'''''''''''''''''''''''''''
' DisplayHelpMessage
'''''''''''''''''''''''''''
Sub DisplayHelpMessage()
    WScript.Echo L_Help_HELP_General01_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General02_Text
    WScript.Echo L_Help_HELP_General02a_Text
    WScript.Echo L_Help_HELP_General03_Text
    WScript.Echo L_Help_HELP_General04_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General05_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General06a_Text
    WScript.Echo L_Help_HELP_General06b_Text
    WScript.Echo L_Help_HELP_General06c_Text
    WScript.Echo L_Help_HELP_General06d_Text
    WScript.Echo L_Help_HELP_General06e_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General08a_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General09a_Text
    WScript.Echo L_Help_HELP_General09b_Text
    WScript.Echo L_Help_HELP_General09c_Text
    WScript.Echo L_Help_HELP_General09d_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_General10a_Text
    WScript.Echo L_Help_HELP_General10b_Text
    WScript.Echo L_Help_HELP_General10c_Text
    WScript.Echo L_Help_HELP_General10d_Text
    WScript.Echo L_Help_HELP_General11_Text
    WScript.Echo L_Help_HELP_General11a_Text
    WScript.Echo L_Help_HELP_General11b_Text
    WScript.Echo L_Help_HELP_General12_Text
    WScript.Echo L_Help_HELP_General12a_Text
    WScript.Echo L_Help_HELP_General12b_Text
    WScript.Echo L_Help_HELP_General13_Text
    WScript.Echo L_Help_HELP_General13a_Text
    WScript.Echo L_Help_HELP_General14_Text
    WScript.Echo L_Help_HELP_General14a_Text
    WScript.Echo L_Help_HELP_General15_Text
    WScript.Echo L_Help_HELP_General15a_Text
    WScript.Echo L_Help_HELP_General16_Text
    WScript.Echo L_Help_HELP_General16a_Text
    WScript.Echo L_Help_HELP_General17_Text
    WScript.Echo L_Help_HELP_General17a_Text
    WScript.Echo L_Help_HELP_General18_Text
    WScript.Echo L_Help_HELP_General19_Text
End Sub

'''''''''''''''''''''''''''
' DisplayHelpMessage
'''''''''''''''''''''''''''
Sub DisplayAddFileHelp()
    WScript.Echo L_Help_HELP_AddFile01_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_AddFile02_Text
    WScript.Echo L_Help_HELP_AddFile02a_Text
    WScript.Echo L_Help_HELP_AddFile03_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General05_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General06a_Text
    WScript.Echo L_Help_HELP_General06b_Text
    WScript.Echo L_Help_HELP_General06c_Text
    WScript.Echo L_Help_HELP_General06d_Text
    WScript.Echo L_Help_HELP_General06e_Text
    WScript.Echo L_Help_HELP_AddFile07_Text
    WScript.Echo L_Help_HELP_AddFile08_Text
    WScript.Echo L_Help_HELP_AddFile09_Text
    WScript.Echo L_Help_HELP_AddFile09a_Text
    WScript.Echo L_Help_HELP_AddFile09b_Text
    WScript.Echo L_Help_HELP_AddFile09c_Text
    WScript.Echo L_Help_HELP_AddFile10_Text
    WScript.Echo L_Help_HELP_AddFile10a_Text
    WScript.Echo L_Help_HELP_AddFile11_Text
    WScript.Echo L_Help_HELP_AddFile11a_Text
    WScript.Echo L_Help_HELP_AddFile11b_Text
    WScript.Echo L_Help_HELP_AddFile12_Text
    WScript.Echo L_Help_HELP_AddFile12a_Text
    WScript.Echo L_Help_HELP_AddFile13_Text
    WScript.Echo L_Help_HELP_AddFile13a_Text
    WScript.Echo L_Help_HELP_AddFile14_Text
    WScript.Echo L_Help_HELP_AddFile14a_Text
    WScript.Echo L_Help_HELP_AddFile15_Text
    WScript.Echo L_Help_HELP_AddFile15a_Text
    WScript.Echo L_Help_HELP_AddFile16_Text
    WScript.Echo L_Help_HELP_AddFile16a_Text
End Sub

Function ChApp(strAppName, intOperation)
    Dim WebSvcObj
    
    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        ChApp = Err.Number
        Exit Function
    End If

    Set WebSvcObj = oScriptHelper.ProviderObj.get("IIsWebService='w3svc'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Adminp2_ErrorMessage

            Case Else
                WScript.Echo L_GetWebSvcObj_ErrorMessage
                oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End Select

        ChApp = Err.Number
        Exit Function
    End If
    
    Select Case intOperation
	    Case OPER_ENAPP
            WebSvcObj.EnableApplication strAppName

	    Case OPER_ENEXT
            WebSvcObj.EnableWebServiceExtension strAppName

	    Case OPER_ENEFI
            WebSvcObj.EnableExtensionFile strAppName
 
	    Case OPER_DSEFI
            WebSvcObj.DisableExtensionFile strAppName
 
    End Select

    If Err.Number Then
		WScript.Echo L_EnApp_ErrorMessage
		WScript.Echo Err.Description
        
        Select Case intOperation
	        Case OPER_ENAPP
                WScript.Echo L_NoApp_ErrorMessage
                WScript.Echo L_NoAppp2_ErrorMessage

	        Case OPER_ENEXT
                WScript.Echo L_NoExt_ErrorMessage

	        Case OPER_ENEFI
                WScript.Echo L_NoEfi_ErrorMessage
     
	        Case OPER_DSEFI
                WScript.Echo L_NoEfi_ErrorMessage
        End Select

        ChApp = Err.Number
        Exit Function
    End If
    
End Function

Function RmEfi(strAppName)
    Dim WebSvcObj, extObj, restrictions, i, bDel
    
    bDel = False

    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        RmEfi = Err.Number
        Exit Function
    End If

    Set WebSvcObj = oScriptHelper.ProviderObj.get("IIsWebService='w3svc'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Adminp2_ErrorMessage

            Case Else
                WScript.Echo L_GetWebSvcObj_ErrorMessage
                oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End Select

        RmEfi = Err.Number
        Exit Function
    End If
    
    Set extObj = oScriptHelper.ProviderObj.get("IIsWebServiceSetting='w3svc'")
    restrictions = extObj.WebSvcExtRestrictionList

    For i=0 to UBOUND(restrictions)
        If UCASE(restrictions(i).FilePath) = UCASE(strAppName) Then
            If restrictions(i).Deletable = 1 Then
                WebSvcObj.DeleteExtensionFileRecord strAppName
                bDel = True
            End If
        End If
    Next
 
    If Err.Number Then
		WScript.Echo L_EnApp_ErrorMessage
		WScript.Echo Err.Description
        
        RmEfi = Err.Number
        Exit Function
    End If
    
    If bDel = False Then
        WScript.Echo L_RmEfi_ErrorMessage
        WScript.Echo L_RmEfip2_ErrorMessage
        RmEfi = 1
    End If
End Function

Function ChDep(aArgs, intOperation)
    Dim WebSvcObj, i
    
    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        ChDep = Err.Number
        Exit Function
    End If

    Set WebSvcObj = oScriptHelper.ProviderObj.get("IIsWebService='w3svc'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Adminp2_ErrorMessage

            Case Else
                WScript.Echo L_GetWebSvcObj_ErrorMessage
                oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End Select

        ChDep = Err.Number
        Exit Function
    End If
    
    If OPER_ADEFI = intOperation Then
        If ((aArgs(1) <> 0) And (aArgs(1) <> 1)) Then
            aArgs(1) = 0
        End If

        WebSvcObj.AddExtensionFile aArgs(0), aArgs(1), aArgs(2), aArgs(3), aArgs(4)
    Else

        If UBOUND(aArgs) < 1 Then
            WScript.Echo L_NotEnoughParams_ErrorMessage
            WScript.Echo L_SeeHelp_Message
            ChDep = ERR_GENERAL_FAILURE
            Exit Function
        End If

        For i=1 to UBOUND(aArgs)
     
            Select Case intOperation
	            Case OPER_ADDDP
                    WebSvcObj.AddDependency aArgs(0), aArgs(i)

	            Case OPER_REMDP
                    WebSvcObj.RemoveDependency aArgs(0), aArgs(i)
            End Select

            If Err.Number Then
		        WScript.Echo L_EnDep_ErrorMessage
		        WScript.Echo Err.Description
                WScript.Echo L_NoDep_ErrorMessage
                WScript.Echo L_NoDepp2_ErrorMessage

                ChDep = Err.Number
                Exit Function
            End If
        Next
    
    End If

    If Err.Number Then
		WScript.Echo L_EnApp_ErrorMessage
		WScript.Echo Err.Description
        
        ChDep = Err.Number
        Exit Function
    End If

End Function

Function DsExt(aArgs)
    Dim WebSvcObj, i
    
    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        DsExt = Err.Number
        Exit Function
    End If

    Set WebSvcObj = oScriptHelper.ProviderObj.get("IIsWebService='w3svc'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Adminp2_ErrorMessage

            Case Else
                WScript.Echo L_GetWebSvcObj_ErrorMessage
                oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End Select

        DsExt = Err.Number
        Exit Function
    End If
    
    For i=0 to UBOUND(aArgs)
 
        WebSvcObj.DisableWebServiceExtension aArgs(i)

        If Err.Number Then
		    WScript.Echo L_EnApp_ErrorMessage
		    WScript.Echo Err.Description
            WScript.Echo L_NoExt_ErrorMessage

            DsExt = Err.Number
            Exit Function
        End If
    Next
    
End Function

Function ShowList(intOperation)
    Dim WebSvcObj, holder, i, mylist
    
    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        ShowList = Err.Number
        Exit Function
    End If

    Set WebSvcObj = oScriptHelper.ProviderObj.get("IIsWebService='w3svc'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Adminp2_ErrorMessage

            Case Else
                WScript.Echo L_GetWebSvcObj_ErrorMessage
                oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End Select

        ShowList = Err.Number
        Exit Function
    End If
    
    Select Case intOperation
	    Case OPER_LSAPP
            set holder=oScriptHelper.ProviderObj.execmethod("IIsWebService='w3svc'", "ListApplications")
            mylist = holder.Applications

	    Case OPER_LSEXT
            set holder=oScriptHelper.ProviderObj.execmethod("IIsWebService='w3svc'", "ListWebServiceExtensions")
            mylist = holder.Extensions

    End Select

    If Err.Number Then
		WScript.Echo L_ShowList_ErrorMessage
		WScript.Echo L_ShowList2_ErrorMessage
		WScript.Echo L_ShowList3_ErrorMessage
		WScript.Echo Err.Description
    
        ShowList = Err.Number
        Exit Function
    End If
    
    For i = 0 to UBOUND(mylist)
        WScript.Echo mylist(i) 
    Next

End Function

Function ShowListFile()
    Dim WebSvcObj, fileList, i
    
    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        ShowList = Err.Number
        Exit Function
    End If

    Set WebSvcObj = oScriptHelper.ProviderObj.get("IIsWebServiceSetting='w3svc'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Adminp2_ErrorMessage

            Case Else
                WScript.Echo L_GetWebSvcObj_ErrorMessage
                oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End Select

        ShowList = Err.Number
        Exit Function
    End If
    
    fileList = WebSvcObj.WebSvcExtRestrictionList

    
    If Err.Number Then
		WScript.Echo L_ShowList_ErrorMessage
		WScript.Echo L_ShowList2_ErrorMessage
		WScript.Echo L_ShowList3_ErrorMessage
		WScript.Echo Err.Description
    
        ShowList = Err.Number
        Exit Function
    End If
    
    WScript.Echo L_Empty_Text
    WScript.Echo L_ShowListFile_Message
    WScript.Echo L_ShowListFile2_Message

    For i = 0 to UBOUND(fileList)
        WScript.Echo fileList(i).Access & "  " & fileList(i).FilePath 
    Next
End Function
