'
' Copyright (c) Microsoft Corporation.  All rights reserved.
'
' VBScript Source File 
'
' Script Name: IIsApp.vbs
'

Option Explicit
On Error Resume Next

' Error codes
Const ERR_OK              = 0
Const ERR_GENERAL_FAILURE = 1

'''''''''''''''''''''
' Messages
Const L_Gen_ErrorMessage               = "%1 : %2"
Const L_CmdLib_ErrorMessage            = "Impossible de crer une instance de l'objet CmdLib."
Const L_ChkCmdLibReg_ErrorMessage      = "Veuillez enregistrer le composant Microsoft.CmdLib."
Const L_ScriptHelper_ErrorMessage      = "Impossible de crer une instance de l'objet IIsScriptHelper."
Const L_ChkScpHelperReg_ErrorMessage   = "Vrifiez si Microsoft.IIsScriptHelper est enregistr."
Const L_InvalidSwitch_ErrorMessage     = "Commutateur non valide : %1"
Const L_NotEnoughParams_ErrorMessage   = "Paramtres insuffisants."
Const L_Query_ErrorMessage             = "Erreur lors de l'excution de la requte."
Const L_Serving_Message                = "Les processus W3WP.exe suivants servent AppPool: %1"
Const L_NoW3_ErrorMessage              = "Erreur - aucun processus w3wp.exe n'est en cours d'excution."
Const L_PID_Message                    = "Identificateur de processus W3WP.exe : %1"
Const L_NoResults_ErrorMessage         = "Erreur - aucun rsultat."
Const L_APID_Message                   = "Identificateur de processus W3WP.exe: %1   Identificateur du pool d'applications: %2"
Const L_NotW3_ErrorMessage             = "Erreur: l'identificateur de processus spcifi n'est pas une instance de W3WP.exe - Sortie du programme."
Const L_PIDNotValid_ErrorMessage       = "Erreur: l'identificateur de processus n'est pas valide."
Const L_Recycled_Message               = "Le recyclage du pool d'applications '%1' a russi."
Const L_PoolDoesntExist_ErrorMessage   = "Le pool d'applications '%1' n'existe pas."
Const L_Recycle_ErrorMessage           = "Le recyclage du pool d'applications '%1' a chou."
Const L_WMIConnect_ErrorMessage        = "Impossible de se connecter au fournisseur WMI."
Const L_PIDNotFound_ErrorMessage       = "L'ID de processus %1 est introuvable."

'''''''''''''''''''''
' Help
Const L_Empty_Text     = ""

' General help messages
Const L_SeeHelp_Message         = "Entrez IIsApp /? pour afficher l'aide."
 
Const L_Help_HELP_General01_Text = "Description: liste les pools d'applications IIS et les processus de travail associs."
Const L_Help_HELP_General02_Text = "             Recyclage des pools d'applications."
Const L_Help_HELP_General03_Text = "Syntaxe: IIsApp.vbs [{ /a <ID_pool_app> | /p <PID> } [/r] ]"
Const L_Help_HELP_General04_Text = "Paramtres :"
Const L_Help_HELP_General05_Text = ""
Const L_Help_HELP_General06_Text = "Valeur             Description"
Const L_Help_HELP_General07_Text = "/a <ID_pool_app>   Spcification d'un pool d'applications par son nom. Mettez"
Const L_Help_HELP_General08_Text = "                   <ID_pool_app> entre guillemets s'il y a des espaces."
Const L_Help_HELP_General09_Text = "                   Utilis seul, sans action d'accompagnement, IIsApp.vbs"
Const L_Help_HELP_General10_Text = "                   rapporte le PID des pools de service excutant des"
Const L_Help_HELP_General11_Text = "                   processus w3wp.exe servant le pool <ID_pool_app>."
Const L_Help_HELP_General12_Text = "/p <PID>           Spcification d'un processus par son PID. Utilis seul,"
Const L_Help_HELP_General13_Text = "                   sans action d'accompagnement, IIsApp.vbs rapporte"
Const L_Help_HELP_General14_Text = "                   le AppPoolId du processus w3wp spcifi par"
Const L_Help_HELP_General15_Text = "                   <PID>. Si un PID est spcifi au moyen de /r, il"
Const L_Help_HELP_General16_Text = "                   se mappe sur un pool d'applications, et l'action s'applique"
Const L_Help_HELP_General17_Text = "                    tout le pool d'applications. Si le PID spcifi est"
Const L_Help_HELP_General18_Text = "                   celui d'un domaine priv Web, c'est--dire un pool"
Const L_Help_HELP_General19_Text = "                   d'applications servi par plusieurs w3wp, tous les w3wp"
Const L_Help_HELP_General20_Text = "                   du pool seront traits."
Const L_Help_HELP_General21_Text = "/r                 Recyclage du pool d'applications."
Const L_Help_HELP_General22_Text = "Par dfaut: aucun commutateur n'imprime les valeurs PID et ID_pool_app."
Const L_Help_HELP_General23_Text = "Exemples:"
Const L_Help_HELP_General24_Text = "IIsApp"
Const L_Help_HELP_General25_Text = "IIsApp /p 2368"
Const L_Help_HELP_General26_Text = "IIsApp /a DefaultAppPool /r"
Const L_Help_HELP_General27_Text = "IIsApp /p 2368 /r"

''''''''''''''''''''''''
' Operation codes
Const OPER_BY_NAME = 1
Const OPER_BY_PID  = 2
Const OPER_ALL     = 3

'
' Main block
'
Dim oScriptHelper, oCmdLib
Dim intOperation, intResult
Dim strCmdLineOptions
Dim oError
Dim aArgs
Dim apoolID, PID
Dim oProviderObj
Dim bRecycle

' Default
intOperation = OPER_ALL
bRecycle = False

Const wmiConnect  = "winmgmts:{(debug)}:/root/cimv2"
Const queryString = "select * from Win32_Process where Name='w3wp.exe'"
Const pidQuery    = "select * from Win32_Process where ProcessId="

' get NT WMI provider
Set oProviderObj = GetObject(wmiConnect)

' Instantiate the CmdLib for output string formatting
Set oCmdLib = CreateObject("Microsoft.CmdLib")
If Err.Number <> 0 Then
    WScript.Echo L_CmdLib_ErrorMessage
    WScript.Echo L_ChkCmdLibReg_ErrorMessage    
    WScript.Quit(ERR_GENERAL_FAILURE)
End If
Set oCmdLib.ScriptingHost = WScript.Application

' Instantiate script helper object
Set oScriptHelper = CreateObject("Microsoft.IIsScriptHelper")
If Err.Number <> 0 Then
    WScript.Echo L_ScriptHelper_ErrorMessage
    WScript.Echo L_ChkScpHelperReg_ErrorMessage    
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

Set oScriptHelper.ScriptHost = WScript

' Check if we are being run with cscript.exe instead of wscript.exe
oScriptHelper.CheckScriptEngine

' Command Line parsing
Dim argObj, arg
Set argObj = WScript.Arguments

strCmdLineOptions = "[a:a:1;r:recycle:0];[p:p:1;r:recycle:0]"

If argObj.Named.Count > 0 Then
    Set oError = oScriptHelper.ParseCmdLineOptions(strCmdLineOptions)

    If Not oError Is Nothing Then
        If oError.ErrorCode = oScriptHelper.ERROR_NOT_ENOUGH_ARGS Then
            ' Not enough arguments for a specified switch
            WScript.Echo L_NotEnoughParams_ErrorMessage
            WScript.Echo L_SeeHelp_Message
        Else
            ' Invalid switch
            oCmdLib.vbPrintf L_InvalidSwitch_ErrorMessage, Array(oError.SwitchName)
      	    WScript.Echo L_SeeHelp_Message
        End If
        
            WScript.Quit(ERR_GENERAL_FAILURE)
    End If

    If oScriptHelper.GlobalHelpRequested Then
        DisplayHelpMessage
        WScript.Quit(ERR_OK)
    End If

    For Each arg In oScriptHelper.Switches
        Select Case arg
            Case "a"
                apoolID = oScriptHelper.GetSwitch(arg)
                intOperation = OPER_BY_NAME
                
            Case "p"
                PID = oScriptHelper.GetSwitch(arg)
                intOperation = OPER_BY_PID
                
            Case "r"
                bRecycle = True
        End Select
    Next

End If

' Choose operation
Select Case intOperation
	Case OPER_BY_NAME
		intResult = GetByPool(apoolID)
		
	Case OPER_BY_PID
		intResult = GetByPid(PID)

    Case OPER_ALL
        intResult = GetAllW3WP()
End Select

' Return value to command processor
WScript.Quit(intResult)

'''''''''''''''''''''''''
' End Of Main Block
'''''''''''''''''''''

'''''''''''''''''''''''''''
' DisplayHelpMessage
'''''''''''''''''''''''''''
Sub DisplayHelpMessage()
    WScript.Echo L_Help_HELP_General01_Text
    WScript.Echo L_Help_HELP_General02_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General03_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General04_Text
    WScript.Echo L_Help_HELP_General05_Text
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_General11_Text
    WScript.Echo L_Help_HELP_General12_Text
    WScript.Echo L_Help_HELP_General13_Text
    WScript.Echo L_Help_HELP_General14_Text
    WScript.Echo L_Help_HELP_General15_Text
    WScript.Echo L_Help_HELP_General16_Text
    WScript.Echo L_Help_HELP_General17_Text
    WScript.Echo L_Help_HELP_General18_Text
    WScript.Echo L_Help_HELP_General19_Text
    WScript.Echo L_Help_HELP_General20_Text
    WScript.Echo L_Help_HELP_General21_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General22_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General23_Text
    WScript.Echo L_Empty_Text
    WScript.Echo L_Help_HELP_General24_Text
    WScript.Echo L_Help_HELP_General25_Text
    WScript.Echo L_Help_HELP_General26_Text
    WScript.Echo L_Help_HELP_General27_Text
End Sub

Function GetAppPoolId(strArg)
	Dim Submatches
	Dim strPoolId
	Dim re
    Dim Matches

    On Error Resume Next

	Set re = New RegExp
	re.Pattern = "-ap ""(.+)"""
	re.IgnoreCase = True
	Set Matches = re.Execute(strArg)
	Set SubMatches = Matches(0).Submatches
	strPoolId = Submatches(0)
	
	GetAppPoolId = strPoolId
End Function

Function GetByPool(strPoolName)
	Dim W3WPList
	Dim strQuery
    Dim W3WP

    On Error Resume Next

    If bRecycle Then
		GetByPool = RecycleAppPool(strPoolName)
		Exit Function
	End If

	strQuery = queryString
	Set W3WPList = oProviderObj.ExecQuery(strQuery)
	If (Err.Number <> 0) Then
		WScript.Echo L_Query_ErrorMessage
        oCmdLib.vbPrintf L_Gen_ErrorMessage, Array(Hex(Err.Number), Err.Description)
		GetByPid = 2
	Else
        oCmdLib.vbPrintf L_Serving_Message, Array(strPoolName)
		If (W3WPList.Count < 1) Then
			WScript.Echo L_NoW3_ErrorMessage
			GetByPool = 1
		Else
			For Each W3WP In W3WPList
				If (UCase(GetAppPoolId(W3WP.CommandLine)) = UCase(strPoolName)) Then
                    oCmdLib.vbPrintf L_PID_Message, Array(W3WP.ProcessId)
				End If
			Next
			GetByPool = 0
		End If
	End If
End Function

Function GetByPid(pid)
    Dim result, poolName

    On Error Resume Next

    result = GetPoolByPid(pid, poolName)
    Select Case result
        ' Successful case
        Case 0
            If bRecycle Then
				result = RecycleAppPool(poolName)
			Else
	            oCmdLib.vbPrintf L_APID_Message, Array(pid, poolName)
            End If
        
        ' No process with such PID was found
        Case &H80070002
            oCmdLib.vbPrintf L_PIDNotFound_ErrorMessage, Array(pid)

        ' Pid should be a number
        Case &H80070057
    		WScript.Echo L_PIDNotValid_ErrorMessage
        
        ' Process found, but it is not a worker process
        Case &H8007000D
    		WScript.Echo L_NotW3_ErrorMessage
    		
    	' Some error occurred
    	Case Default
			WScript.Echo L_Query_ErrorMessage
            oCmdLib.vbPrintf L_Gen_ErrorMessage, Array(Hex(Err.Number), Err.Description)
    End Select

    GetByPid = result
End Function
    
Function GetPoolByPid( pid, ByRef poolName )
	Dim W3WPList
    Dim strQuery
    Dim W3WP

    On Error Resume Next

    poolName = ""
	If IsNumeric(pid) Then
		strQuery = pidQuery & pid
	
		Set W3WPList = oProviderObj.ExecQuery(strQuery)
		If Err.Number <> 0 Then
			GetPoolByPid = Err.Number
		Else
			If W3WPList.Count < 1 Then
				GetPoolByPid = &H80070002
			Else
				For Each W3WP In W3WPList
					If UCase(W3WP.Name) = "W3WP.EXE" Then
						poolName = GetAppPoolId(W3WP.CommandLine)
						GetPoolByPid = 0
					Else
						GetPoolByPid = &H8007000D
					End If
				Next
			End If
		End If
	Else
		GetPoolByPid = &H80070057
	End If
End Function

Function GetAllW3WP()
	Dim W3WPList
	Dim strQuery
    Dim W3WP

    On Error Resume Next

	strQuery = queryString
	Set W3WPList = oProviderObj.ExecQuery(strQuery)
	If (Err.Number <> 0) Then
		WScript.Echo L_Query_ErrorMessage
        oCmdLib.vbPrintf L_Gen_ErrorMessage, Array(Hex(Err.Number), Err.Description)
		GetByPid = 2
	Else
		If (W3WPList.Count < 1) Then
			WScript.Echo L_NoResults_ErrorMessage
			GetAllW3WP = 2
		Else
			For Each W3WP In W3WPList
                oCmdLib.vbPrintf L_APID_Message, Array(W3WP.ProcessId, GetAppPoolId(W3WP.CommandLine))
			Next
			GetAllW3WP = 0
		End If
	End If
End Function

Function RecycleAppPool(apoolID)
    Dim PoolObj
    
    On Error Resume Next
    
    ' Initializes authentication with remote machine
    intResult = oScriptHelper.InitAuthentication(".", "", "")
    If intResult <> 0 Then
        RecycleAppPool = intResult
        Exit Function
    End If

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Gen_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        RecycleAppPool = Err.Number
        Exit Function
    End If

    Set PoolObj = oScriptHelper.ProviderObj.Get("IIsApplicationPool='W3SVC/AppPools/" & apoolID & "'")
    If Err.Number Then
        If Err.Number = &H80070003 Then
            oCmdLib.vbPrintf L_PoolDoesntExist_ErrorMessage, Array(apoolID)
        Else
            oCmdLib.vbPrintf L_Gen_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End If
        
        RecycleAppPool = Err.Number
        Exit Function
    End If
    
    PoolObj.Recycle
    If Err.Number Then
        oCmdLib.vbPrintf L_Recycle_ErrorMessage, Array(apoolID)
        oCmdLib.vbPrintf L_Gen_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        RecycleAppPool = Err.Number
        Exit Function
    End If
    
    oCmdLib.vbPrintf L_Recycled_Message, Array(apoolID)
    RecycleAppPool = 0
End Function
