'
' Copyright (c) Microsoft Corporation.  All rights reserved.
'
' VBScript Source File 
'
' Script Name: IIsVDir.vbs
'

Option Explicit
On Error Resume Next

' Error codes
Const ERR_OK              = 0
Const ERR_GENERAL_FAILURE = 1

'''''''''''''''''''''
' Messages
Const L_WebDir_Message           = "Le rpertoire Web  %1 a t supprim"
Const L_InvalidPath_ErrorMessage = "Chemin du site non valide."

Const L_VPath_Message        = "Chemin virtuel"
Const L_Root_Message         = "Racine"
Const L_MetabasePath_Message = "Chem. mtabase"
Const L_AliasName_Text       = "Alias"
Const L_Path_Text            = "Racine physique"

Const L_Error_ErrorMessage                = "Erreur &H%1 : %2"
Const L_AppRecursiveDel_ErrorMessage      = "Impossible de supprimer l'application rcursivement du rpertoire Web."
Const L_VDirDel_ErrorMessage              = "Impossible de supprimer le rpertoire Web."
Const L_CannotCreateDir_ErrorMessage      = "Impossible de crer un rpertoire racine."
Const L_DirFormat_ErrorMessage            = "Format du rpertoire racine inconnu. Utilisez le"
Const L_DirFormat2_ErrorMessage           = "format '<lecteur>:\<chemin>'."
Const L_AppCreate_ErrorMessage            = "Une erreur s'est produite lors de la cration d'une application pooled-proc sur le nouveau rpertoire"
Const L_AppCreate2_ErrorMessage           = "Web."
Const L_OperationRequired_ErrorMessage    = "Spcifiez une opration avant les arguments."
Const L_NotEnoughParam_ErrorMessage       = "Paramtres insuffisants."
Const L_Query_ErrorMessage                = "Une erreur s'est produite lors d'une requte auprs du fournisseur WMI."
Const L_VDirExists1_ErrorMessage          = "Le rpertoire virtuel %1 n'existe pas."
Const L_VDirExists2_ErrorMessage          = "Le rpertoire virtuel %1 existe dj."
Const L_VDirDoesntExist_ErrorMessage      = "Le chemin d'accs spcifi n'est pas un objet IIsVirtualDir ou"
Const L_VDirDoesntExist2_ErrorMessage     = "le chemin d'accs n'existe pas (%1)"
Const L_OnlyOneOper_ErrorMessage          = "Spcifier une opration en un temps donn."
Const L_ScriptHelper_ErrorMessage         = "Impossible de crer une instance de l'objet IIsScriptHelper."
Const L_CmdLib_ErrorMessage               = "Impossible de crer une instance de l'objet CmdLib."
Const L_ChkCmdLibReg_ErrorMessage         = "Veuillez enregistrer le composant Microsoft.CmdLib."
Const L_ChkScpHelperReg_ErrorMessage      = "Veuillez enregistrer le composant Microsoft.IIsScriptHelper."
Const L_VDirsNotFound_ErrorMessage        = "Aucun sous-rpertoire virtuel n'est disponible."
Const L_SiteNotFound_ErrorMessage         = "Impossible de trouver le site Web %1"
Const L_PassWithoutUser_ErrorMessage      = "Spcifier le commutateur /u avant /p."
Const L_WMIConnect_ErrorMessage           = "Impossible de se connecter au fournisseur WMI."
Const L_MapDrive_ErrorMessage             = "Impossible de mapper le lecteur rseau."
Const L_GetSetting_ErrorMessage           = "Impossible d'obtenir la classe Paramtre de l'espace de noms IIS."
Const L_CannotDelRoot_ErrorMessage        = "Impossible de supprimer le rpertoire virtuel racine. Spcifiez"
Const L_CannotDelRoot2_ErrorMessage       = "un autre rpertoire."
Const L_WrongVDirPath_ErrorMessage        = "Le rpertoire virtuel parent pointe vers un chemin d'accs"
Const L_WrongVDirPath2_ErrorMessage       = "de systme de fichiers inexistant."
Const L_CannotBuildNameSpace_ErrorMessage = "Impossible de construire l'espace de noms de la mtabase pour le nouveau"
Const L_CannotBuildNameSpace2_ErrorMessage = "rpertoire virtuel."
Const L_KeyIsntVDir_ErrorMessage          = "Le chemin d'accs de la mtabase spcifie n'est pas un rpertoire virtuel."
Const L_CannotGetVDir_ErrorMessage        = "Le chemin d'accs n'existe pas ou ce n'est pas un"
Const L_CannotGetVDir2_ErrorMessage       = "rpertoire virtuel. Assurez-vous que le chemin d'accs spcifi est"
Const L_CannotGetVDir3_ErrorMessage       = "valide."
Const L_InvalidAlias_ErrorMessage         = "L'alias contient des caractres non valides."
Const L_NotEnoughParams_ErrorMessage      = "Paramtres insuffisants."
Const L_InvalidSwitch_ErrorMessage        = "Commutateur non valide : %1"
Const L_Admin_ErrorMessage                = "Vous ne pouvez pas excuter cette commande car vous n'tes pas"
Const L_Admin2_ErrorMessage               = "un administrateur sur le serveur que vous essayez de configurer."

'''''''''''''''''''''
' Help

' General help messages
Const L_SeeHelp_Message          = "Entrez IIsVDir /? pour afficher l'aide."
Const L_SeeCreateHelp_Message    = "Entrez IIsVDir /create /? pour afficher l'aide."
Const L_SeeDeleteHelp_Message    = "Entrez IIsVDir /delete /? pour afficher l'aide."
Const L_SeeQueryHelp_Message     = "Entrez IIsVDir /query /? pour afficher l'aide."

Const L_Help_HELP_General01_Text  = "Description: cre, supprime ou effectue une requte du rpertoire Web"
Const L_Help_HELP_General02_Text  = "Syntaxe: IIsVDir [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]]"
Const L_Help_HELP_General03_Text  = "        /<opration> [arguments]"
Const L_Help_HELP_General04_Text  = "Paramtres:"
Const L_Help_HELP_General06_Text  = "Valeur                  Description"
Const L_Help_HELP_General07_Text  = "/s <serveur>            Connecter  l'ordinateur <serveur>"
Const L_Help_HELP_General07a_Text = "                        [Par dfaut: ce systme]"
Const L_Help_HELP_General08_Text  = "/u <utilisateur>        Connecter en tant que <domaine>\<utilisateur> ou"
Const L_Help_HELP_General09_Text  = "                        <nom_utilisateur> [Par dfaut: l'utilisateur actuel]"
Const L_Help_HELP_General10_Text  = "/p <mot_passe>          Mot de passe de l'utilisateur <nom_utilisateur>"
Const L_Help_HELP_General11_Text  = "<opration>             /create  Cre un rpertoire Web virtuel"
Const L_Help_HELP_General12_Text  = "                                 sur un site Web spcifi."
Const L_Help_HELP_General13_Text  = "                        /delete  Supprime un rpertoire virtuel"
Const L_Help_HELP_General14_Text  = "                                 d'un site Web spcifi."
Const L_Help_HELP_General15_Text  = "                        /query   Liste tous les rpertoires virtuels"
Const L_Help_HELP_General16_Text  = "                                 sous le chemin d'accs spcifi."
Const L_Help_HELP_General17_Text  = "Pour une utilisation dtaille :"
Const L_Help_HELP_General18_Text  = "IIsVDir /create /?"
Const L_Help_HELP_General19_Text  = "IIsVDir /delete /?"
Const L_Help_HELP_General20_Text  = "IIsVDir /query /?"

' Common to all status change commands
Const L_Help_HELP_Common03_Text   = "Paramtres:"
Const L_Help_HELP_Common09_Text   = "<site_Web>              Utiliser le nom du site ou le chemin d'accs"
Const L_Help_HELP_Common09p1_Text = "                        de la mtabase pour spcifier le site. (""Site"
Const L_Help_HELP_Common09p2_Text = "                        Web par dfaut"" ou w3svc/1)"
Const L_Help_HELP_Common10_Text   = "<chemin>                Chemin d'accs virtuel pour le nouveau"
Const L_Help_HELP_Common10p1_Text = "                        rpertoire virtuel parent. Ce chemin"
Const L_Help_HELP_Common10p2_Text = "                        d'accs virtuel doit dj exister."
Const L_Help_HELP_Common11_Text   = "Exemples:"

' Delete help messages
Const L_Help_HELP_Delete01_Text   = "Description: supprimer un rpertoire Web virtuel"
Const L_Help_HELP_Delete01p1_Text = "              d'un site Web spcifi."
Const L_Help_HELP_Delete02_Text   = "Syntaxe: IIsVDir [/s <serveur> [/u <nom_utilisateur> [/p <mot_de_passe>]]]"
Const L_Help_HELP_Delete02p1_Text = "        /delete <site_Web>[/chemin]<alias>"
Const L_Help_HELP_Delete11_Text   = "IIsVDir /delete ""Mon Site""/MonRp"
Const L_Help_HELP_Delete12_Text   = "IIsVDir /delete w3svc/1/ROOT/Users/Public/MonRp"
Const L_Help_HELP_Delete13_Text   = "IIsVDir /s Serveur1 /u Administrateur /p m0t_p@sSe /delete ""Mon Site""/MonRp"

' Query help messages
Const L_Help_HELP_Query01_Text   = "Description: liste tous les rpertoires virtuels sous un chemin"
Const L_Help_HELP_Query01p1_Text = "              d'accs donn."
Const L_Help_HELP_Query02_Text   = "Syntaxe: IIsVDir [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]]"
Const L_Help_HELP_Query02p1_Text = "        /query <site_Web>[/chemin]"
Const L_Help_HELP_Query11_Text   = "IIsVDir /query ""Mon Site"""
Const L_Help_HELP_Query12_Text   = "IIsVDir /query w3svc/1/ROOT"
Const L_Help_HELP_Query13_Text   = "IIsVDir /query ""Mon Site""/Users/Public"
Const L_Help_HELP_Query14_Text   = "IIsVDir /s Serveur1 /u Administrateur /p m0t_p@sSe /query ""Mon Site""/Users"

' Create help messages
Const L_Help_HELP_Create01_Text   = "Description: cre un rpertoire Web virtuel sur un"
Const L_Help_HELP_Create01p1_Text = "              site Web spcifi."
Const L_Help_HELP_Create02_Text   = "Syntaxe: IIsVDir [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]] /create"
Const L_Help_HELP_Create02p1_Text = "        <site_Web>[/chemin] <alias> <racine>"
Const L_Help_HELP_Create11_Text   = "<alias>                 Le nom du rpertoire virtuel"
Const L_Help_HELP_Create12_Text   = "<racine>                Chemin d'accs physique du rpertoire"
Const L_Help_HELP_Create12p1_Text = "                        virtuel. Si le rpertoire physique"
Const L_Help_HELP_Create12p2_Text = "                        n'existe pas, il sera cr."
Const L_Help_HELP_Create15_Text   = "IIsVDir /create ""Mon Site"" MonRp c:\monrp"
Const L_Help_HELP_Create16_Text   = "IIsVDir /create w3svc/1/ROOT MonRp c:\monrp"
Const L_Help_HELP_Create17_Text   = "IIsVDir /create ""Mon Site""/Users/Public MonRp c:\monrp"
Const L_Help_HELP_Create18_Text   = "IIsVDir /s Serveur1 /u Administrateur /p m0t_p@sSe /create ""Mon Site"" MonRp"
Const L_Help_HELP_Create19_Text   = "        c:\monrp"

''''''''''''''''''''''''
' Operation codes
Const OPER_DELETE = 1
Const OPER_CREATE = 2
Const OPER_QUERY  = 3

'
' Main block
'
Dim oScriptHelper, oCmdLib
Dim strServer, strUser, strPassword, strSite
Dim strPath, strVPath, strAlias, strRoot
Dim intOperation, intResult
Dim aArgs, arg
Dim strCmdLineOptions
Dim oError

' Default values
strServer = "."
strUser = ""
strPassword = ""
intOperation = 0
strSite = ""
strPath = ""

' Instantiate the CmdLib for output string formatting
Set oCmdLib = CreateObject("Microsoft.CmdLib")
If Err.Number <> 0 Then
    WScript.Echo L_CmdLib_ErrorMessage
    WScript.Echo L_ChkCmdLibReg_ErrorMessage    
    WScript.Quit(ERR_GENERAL_FAILURE)
End If
Set oCmdLib.ScriptingHost = WScript.Application

' Instantiate script helper object
Set oScriptHelper = CreateObject("Microsoft.IIsScriptHelper")
If Err.Number <> 0 Then
    WScript.Echo L_ScriptHelper_ErrorMessage
    WScript.Echo L_ChkScpHelperReg_ErrorMessage    
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

Set oScriptHelper.ScriptHost = WScript

' Check if we are being run with cscript.exe instead of wscript.exe
oScriptHelper.CheckScriptEngine

' Minimum number of parameters must exist
If WScript.Arguments.Count < 1 Then
    WScript.Echo L_NotEnoughParam_ErrorMessage
	WScript.Echo L_SeeHelp_Message
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

strCmdLineOptions = "[server:s:1;user:u:1;password:p:1];delete:d:1;create:c:3;query:q:1"
Set oError = oScriptHelper.ParseCmdLineOptions(strCmdLineOptions)

If Not oError Is Nothing Then
    If oError.ErrorCode = oScriptHelper.ERROR_NOT_ENOUGH_ARGS Then
        ' Not enough arguments for a specified switch
        WScript.Echo L_NotEnoughParams_ErrorMessage
        Select Case LCase(oError.SwitchName)
            Case "create"
                WScript.Echo L_SeeCreateHelp_Message
            
            Case "delete"
                WScript.Echo L_SeeDeleteHelp_Message

            Case "query"
                WScript.Echo L_SeeQueryHelp_Message

            Case Else
           	    WScript.Echo L_SeeHelp_Message
        End Select
    Else
        ' Invalid switch
        oCmdLib.vbPrintf L_InvalidSwitch_ErrorMessage, Array(oError.SwitchName)
      	WScript.Echo L_SeeHelp_Message
    End If
        
        WScript.Quit(ERR_GENERAL_FAILURE)
End If

If oScriptHelper.GlobalHelpRequested Then
    DisplayHelpMessage
    WScript.Quit(ERR_OK)
End If
    
For Each arg In oScriptHelper.Switches
    Select Case arg
        Case "server"
            ' Server information
            strServer = oScriptHelper.GetSwitch(arg)

        Case "user"
            ' User information
            strUser = oScriptHelper.GetSwitch(arg)

        Case "password"
            ' Password information
            strPassword = oScriptHelper.GetSwitch(arg)
        
        Case "create"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

            intOperation = OPER_CREATE

           	If oScriptHelper.IsHelpRequested(arg) Then
            	DisplayCreateHelpMessage
            	WScript.Quit(ERR_OK)
            End If

            aArgs = oScriptHelper.GetSwitch(arg)

        	strVPath = aArgs(0)
            strAlias = aArgs(1)
            strRoot = aArgs(2)

        Case "delete"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If
        
            intOperation = OPER_DELETE

        	If oScriptHelper.IsHelpRequested(arg) Then
        		DisplayDeleteHelpMessage
        		WScript.Quit(ERR_OK)
        	End If

            strPath = oScriptHelper.GetSwitch(arg)

        Case "query"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If
        
            intOperation = OPER_QUERY

        	If oScriptHelper.IsHelpRequested(arg) Then
        		DisplayQueryHelpMessage
        		WScript.Quit(ERR_OK)
        	End If

            strPath = oScriptHelper.GetSwitch(arg)
    End Select
Next
    
' Check Parameters
If (intOperation = 0) Then
    WScript.Echo L_OperationRequired_ErrorMessage
    WScript.Echo L_SeeHelp_Message
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

' Check if /p is specified but /u isn't. In this case, we should bail out with an error
If oScriptHelper.Switches.Exists("password") And Not oScriptHelper.Switches.Exists("user") Then
    WScript.Echo L_PassWithoutUser_ErrorMessage
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

' Check if /u is specified but /p isn't. In this case, we should ask for a password
If oScriptHelper.Switches.Exists("user") And Not oScriptHelper.Switches.Exists("password") Then
    strPassword = oCmdLib.GetPassword
End If

' Initializes authentication with remote machine
intResult = oScriptHelper.InitAuthentication(strServer, strUser, strPassword)
If intResult <> 0 Then
    WScript.Quit(intResult)
End If

' Choose operation
Select Case intOperation
	Case OPER_CREATE
		intResult = CreateWebVDir(strVPath, strAlias, strRoot)
		
	Case OPER_DELETE
		intResult = DeleteWebVDir(strPath)

	Case OPER_QUERY
		intResult = QueryWebVDir(strPath)
End Select

' Return value to command processor
WScript.Quit(intResult)

'''''''''''''''''''''''''
' End Of Main Block
'''''''''''''''''''''

'''''''''''''''''''''''''''
' ParseSitePath
'''''''''''''''''''''''''''
Function ParseSitePath(strSitePath)
    Dim iFirstSlash, iSecondSlash, iIndex
    Dim strSite, strPath
    Dim aPath, aWebSites
    
    On Error Resume Next
    
    ' Replace any existing back-slashes with forward-slashes
    strSitePath = Replace(strSitePath, "\", "/")
    
    aPath = Split(strSitePath, "/", -1)

    ' Fills strPath
    If (UCase(aPath(0)) = "W3SVC") Then
        ' First argument is a metabase path
        If (UBound(aPath) < 1) Then
            WScript.Echo L_InvalidPath_ErrorMessage
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If
        
        ' Second array element must be a number (site ID)
        If Not IsNumeric(aPath(1)) Then
            WScript.Echo L_InvalidPath_ErrorMessage
            WScript.Quit(ERR_GENERAL_FAILURE)
        End If
        
        ' Second element of aPath should be the site number so ...
        strPath = "W3SVC/" & aPath(1)
        
        ' Call FindWebSite to make sure web site exists
        aWebSites = oScriptHelper.FindSite("Web", Array(strPath))
        If IsArray(aWebSites) Then
            If UBound(aWebSites) = -1 Then
            	oCmdLib.vbPrintf L_SiteNotFound_ErrorMessage, Array(strPath)
            	ParseSitePath = Empty
            	Exit Function
            End If
        End If

        strPath = strPath & "/ROOT"
        strSitePath = strPath
        
        ' Check for ROOT string and grab the rest for strPath
        iIndex = 1
        If (UBound(aPath) > 1) Then
            If (UCase(aPath(2)) = "ROOT") Then
                iIndex = 2
            End If
        End If
        
    Else
        ' First argument is a site name (server comment property)
        ' Call FindWebSite to resolve site name to metabase path
        aWebSites = oScriptHelper.FindSite("Web", Array(aPath(0)))
        If IsArray(aWebSites) Then
            If UBound(aWebSites) = -1 Then
            	oCmdLib.vbPrintf L_SiteNotFound_ErrorMessage, Array(aPath(0))
            	ParseSitePath = Empty
            	Exit Function
            Else
                strPath = aWebSites(0)
            End If
        Else
            ' Got duplicate sites. We should quit.
            ParseSitePath = Empty
            Exit Function
        End If
        
        strPath = strPath & "/ROOT"

        strSitePath = aPath(0) & "/ROOT"

        ' Check for ROOT string and grab the rest for strPath
        iIndex = 0
        If (UBound(aPath) > 0) Then
            If (UCase(aPath(1)) = "ROOT") Then
                iIndex = 1
            End If
        End If

    End If

    ' Build strPath    
    iIndex = iIndex + 1
    Do While iIndex <= UBound(aPath)
        If (aPath(iIndex) = "") Then
            Exit Do
        End If
        
        strPath = strPath & "/" & aPath(iIndex)
        strSitePath = strSitePath & "/" & aPath(iIndex)

        iIndex = iIndex + 1
    Loop
    
    ParseSitePath = strPath
End Function


'''''''''''''''''''''''''''
' DisplayHelpMessage
'''''''''''''''''''''''''''
Sub DisplayHelpMessage()
    WScript.Echo L_Help_HELP_General01_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_General02_Text
    WScript.Echo L_Help_HELP_General03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General04_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_General11_Text
    WScript.Echo L_Help_HELP_General12_Text
    WScript.Echo L_Help_HELP_General13_Text
    WScript.Echo L_Help_HELP_General14_Text
    WScript.Echo L_Help_HELP_General15_Text
    WScript.Echo L_Help_HELP_General16_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General17_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General18_Text
    WScript.Echo L_Help_HELP_General19_Text
    WScript.Echo L_Help_HELP_General20_Text
End Sub

Sub DisplayDeleteHelpMessage()
    WScript.Echo L_Help_HELP_Delete01_Text
    WScript.Echo L_Help_HELP_Delete01p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Delete02_Text
    WScript.Echo L_Help_HELP_Delete02p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Common03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Common09_Text
    WScript.Echo L_Help_HELP_Common09p1_Text
    WScript.Echo L_Help_HELP_Common09p2_Text
    WScript.Echo L_Help_HELP_Common10_Text
    WScript.Echo L_Help_HELP_Common10p1_Text
    WScript.Echo L_Help_HELP_Common10p2_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Common11_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Delete11_Text
    WScript.Echo L_Help_HELP_Delete12_Text
    WScript.Echo L_Help_HELP_Delete13_Text
End Sub

Sub DisplayCreateHelpMessage()
    WScript.Echo L_Help_HELP_Create01_Text
    WScript.Echo L_Help_HELP_Create01p1_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_Create02_Text
    WScript.Echo L_Help_HELP_Create02p1_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_Common03_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Common09_Text
    WScript.Echo L_Help_HELP_Common09p1_Text
    WScript.Echo L_Help_HELP_Common09p2_Text
    WScript.Echo L_Help_HELP_Common10_Text
    WScript.Echo L_Help_HELP_Common10p1_Text
    WScript.Echo L_Help_HELP_Common10p2_Text
    WScript.Echo L_Help_HELP_Create11_Text
    WScript.Echo L_Help_HELP_Create12_Text
    WScript.Echo L_Help_HELP_Create12p1_Text
    WScript.Echo L_Help_HELP_Create12p2_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_Common11_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_Create15_Text
    WScript.Echo L_Help_HELP_Create16_Text
    WScript.Echo L_Help_HELP_Create17_Text
    WScript.Echo L_Help_HELP_Create18_Text
    WScript.Echo L_Help_HELP_Create19_Text
End Sub

Sub DisplayQueryHelpMessage()
    WScript.Echo L_Help_HELP_Query01_Text
    WScript.Echo L_Help_HELP_Query01p1_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_Query02_Text
    WScript.Echo L_Help_HELP_Query02p1_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_Common03_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Common09_Text
    WScript.Echo L_Help_HELP_Common09p1_Text
    WScript.Echo L_Help_HELP_Common09p2_Text
    WScript.Echo L_Help_HELP_Common10_Text
    WScript.Echo L_Help_HELP_Common10p1_Text
    WScript.Echo L_Help_HELP_Common10p2_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_Common11_Text
    WScript.Echo
    WScript.Echo L_Help_HELP_Query11_Text
    WScript.Echo L_Help_HELP_Query12_Text
    WScript.Echo L_Help_HELP_Query13_Text
    WScript.Echo L_Help_HELP_Query14_Text
End Sub

'''''''''''''''''''''''''''
' DeleteWebVDir
'''''''''''''''''''''''''''
Function DeleteWebVDir(strVPath)
	Dim strPath, ServiceObj
	Dim rootVDirObj, providerObj
	
	On Error Resume Next
	
    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        ChangeWebSiteStatus = Err.Number
        Exit Function
    End If

	Set providerObj = oScriptHelper.ProviderObj

    ' Quick check to see if we have permission
    Set ServiceObj = providerObj.Get("IIsWebService='W3SVC'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Admin2_ErrorMessage

            Case Else
                WScript.Echo Err.Description
        End Select
        
        DeleteWebVDir = Err.Number
        Exit Function
    End If

    strPath = ParseSitePath(strVPath)
    If IsEmpty(strPath) Then
        ' Got problems parsing the path
        WScript.Echo L_SeeDeleteHelp_Message
        DeleteWebVDir = ERR_GENERAL_FAILURE
        Exit Function
    End If
    
    ' Don't delete ROOT Vdir
    If UCase(Right(strPath, 5)) = "/ROOT" Then
        WScript.Echo L_CannotDelRoot_ErrorMessage
        WScript.Echo L_CannotDelRoot2_ErrorMessage
        DeleteWebVDir = ERR_GENERAL_FAILURE
        Exit Function
    End If
    
    ' Check vdir existance
    Set rootVDirObj = providerObj.Get("IIsWebVirtualDir='" & strPath & "'")
	If Err.Number Then
	    Select Case Err.Number
	        Case &H80041002
                WScript.Echo L_VDirDoesntExist_ErrorMessage
		        oCmdLib.vbPrintf L_VDirDoesntExist2_ErrorMessage, Array(strVPath)
		
		    Case &H8004103A
		        WScript.Echo L_KeyIsntVDir_ErrorMessage
		        
		    Case Else
                oCmdLib.vbPrintf L_VDirExists1_ErrorMessage, Array(strVPath)
		        WScript.Echo L_CannotGetVDir_ErrorMessage
		        WScript.Echo L_CannotGetVDir2_ErrorMessage
		        WScript.Echo L_CannotGetVDir3_ErrorMessage
		End Select
		
		DeleteWebVDir = Err.Number
		Exit Function
    End If
	
   	' First delete application recursively in this vdir
    rootVDirObj.AppDelete(True)
	If Err.Number Then
		WScript.Echo L_AppRecursiveDel_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
		DeleteWebVDir = Err.Number
		Exit Function
    End If
		
    rootVDirObj.Delete_()
	If Err.Number Then
		WScript.Echo L_VDirDel_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
		DeleteWebVDir = Err.Number
		Exit Function
    End If

   	oCmdLib.vbPrintf L_WebDir_Message, Array(strVPath)
    
    DeleteWebVDir = ERR_OK
End Function


'''''''''''''''''''''''''''
' CreateWebVDir
'''''''''''''''''''''''''''
Function CreateWebVDir(strVPath, strAlias, strRoot)
	Dim strPath, strStatus, strNewVdir, strRootVDir
	Dim vdirClassObj, serverObj, vdirObj, providerObj
	Dim intResult, ServiceObj

    Const APP_POOLED = 2
	
	On Error Resume Next
	
    ' Parse Alias for correctness
    If InStr(strAlias, "/") <> 0 Or InStr(strAlias, "\") <> 0 Then
        WScript.Echo L_InvalidAlias_ErrorMessage
        WScript.Echo L_SeeCreateHelp_Message
        CreateWebVDir = ERR_GENERAL_FAILURE
        Exit Function
    End If

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        CreateWebVDir = Err.Number
        Exit Function
    End If

	Set providerObj = oScriptHelper.ProviderObj
	
    ' Quick check to see if we have permission
    Set ServiceObj = providerObj.Get("IIsWebService='W3SVC'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Admin2_ErrorMessage

            Case Else
                WScript.Echo Err.Description
        End Select
        
        CreateWebVDir = Err.Number
        Exit Function
    End If

    ' Extract options from array to the correspondent variables
    strPath = ParseSitePath(strVPath)
    If IsEmpty(strPath) Then
        ' Got problems parsing the path
        WScript.Echo L_SeeCreateHelp_Message
        CreateWebVDir = ERR_GENERAL_FAILURE
        Exit Function
    End If

    ' Build new vdir name
    strNewVdir = strPath & "/" & strAlias
    
    ' Check if vdir already exists
    Set vdirObj = providerObj.Get("IIsWebDirectorySetting='" & strNewVdir & "'")
    If Err.Number = 0 Then
        oCmdLib.vbPrintf L_VDirExists2_ErrorMessage, Array(strNewVdir)
        CreateWebVDir = ERR_GENERAL_FAILURE
        Exit Function
    End If
    Err.Clear

    Set vdirObj = providerObj.Get("IIsWebVirtualDirSetting='" & strNewVdir & "'")
    If Err.Number = 0 Then
        oCmdLib.vbPrintf L_VDirExists2_ErrorMessage, Array(strNewVdir)
        CreateWebVDir = ERR_GENERAL_FAILURE
        Exit Function
    End If
    Err.Clear
    
	' Create physical directory
	oScriptHelper.CreateFSDir strRoot
	If Err.Number Then
    	Select Case Err.Number
    	    Case &H8007000C
                WScript.Echo L_DirFormat_ErrorMessage
                WScript.Echo L_DirFormat2_ErrorMessage
                WScript.Echo L_SeeCreateHelp_Message
    	    
    	    Case &H8007000F
    	        WScript.Echo L_MapDrive_ErrorMessage
    
        	Case Else
    	        WScript.Echo L_CannotCreateDir_ErrorMessage
                oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End Select

        CreateWebVDir = Err.Number
        Exit Function
    End If

    ' Check if we have a contiguous name space in the metabase and file system
    oScriptHelper.BuildNameSpace strPath
    If Err.Number Then
    	Select Case Err.Number
    	    Case &H80070003
                WScript.Echo L_WrongVDirPath_ErrorMessage
                WScript.Echo L_WrongVDirPath2_ErrorMessage
    	    
        	Case Else
    	        WScript.Echo L_CannotBuildNameSpace_ErrorMessage
    	        WScript.Echo L_CannotBuildNameSpace2_ErrorMessage
                oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        End Select

        CreateWebVDir = Err.Number
        Exit Function
    End If

    ' Remove trailing slash (if present)
    If (Right(strRoot, 1) = "\") Then
        strRoot = Left(strRoot, Len(strRoot) - 1)
    End If

    ' Create new web virtual directory
    Set vdirClassObj = providerObj.Get("IIsWebVirtualDirSetting")
    Set vdirObj = vdirClassObj.SpawnInstance_()
    vdirObj.Name = strNewVdir
    vdirObj.Path = strRoot

    ' Set web virtual directory properties
    vdirObj.AuthFlags = 5 ' AuthNTLM + AuthAnonymous
    vdirObj.EnableDefaultDoc = True
    vdirObj.DirBrowseFlags = &H4000003E ' date, time, size, extension, longdate
    vdirObj.AccessFlags = 513 ' read, script
	vdirObj.Put_()

    ' Create Pooled-proc application on ROOT WebVDir
    Set vdirObj = providerObj.Get("IIsWebVirtualDir='" & strNewVdir & "'")
    vdirObj.AppCreate2(APP_POOLED)
    If Err.Number Then
        WScript.Echo L_AppCreate_ErrorMessage
        WScript.Echo L_AppCreate2_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        intResult = ERR_GENERAL_FAILURE
    End If
    
    ' Update AppFriendlyName property
    Set vdirObj = providerObj.Get("IIsWebVirtualDirSetting='" & strNewVdir & "'")
    vdirObj.AppFriendlyName = strAlias
	vdirObj.Put_()
    
    ' Remove trailing slash (if present)
    If (Right(strVPath, 1) = "/") Then
        strVPath = Left(strVPath, Len(strVPath) - 1)
    End If
    
	If (strServer = ".") Then 
	    strServer = oScriptHelper.GetEnvironmentVar("%COMPUTERNAME%")
	End If

    ' Post summary
    WScript.Echo L_Server_Message & Space(14 - Len(L_Server_Message)) & "= " & UCase(strServer)
    WScript.Echo L_VPath_Message & Space(14 - Len(L_VPath_Message)) & "= " & strVPath & "/" & strAlias
    WScript.Echo L_Root_Message & Space(14 - Len(L_Root_Message)) & "= " & strRoot
    WScript.Echo L_MetabasePath_Message & Space(14 - Len(L_MetabasePath_Message)) & "= " & strNewVdir
    
    CreateWebVDir = intResult
End Function


'''''''''''''''''''''''''''
' Helper Functions
'''''''''''''''''''''''''''

'''''''''''''''''''''''''''
' QueryWebVDir
'''''''''''''''''''''''''''
Function QueryWebVDir(strVDir)
	Dim Servers, Server, strQuery
	Dim bFirstIteration
	Dim vdirObj, providerObj
	Dim strServer, strPath, strVDirName
    Dim firstLen, ServiceObj
	
    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        QueryWebVDir = Err.Number
        Exit Function
    End If

    Set providerObj = oScriptHelper.ProviderObj

    ' Quick check to see if we have permission
    Set ServiceObj = providerObj.Get("IIsWebService='W3SVC'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Admin2_ErrorMessage

            Case Else
                WScript.Echo Err.Description
        End Select
        
        QueryWebVDir = Err.Number
        Exit Function
    End If

	strPath = ParseSitePath(strVDir)
    If IsEmpty(strPath) Then
        ' Got problems parsing the path
        WScript.Echo L_SeeQueryHelp_Message
        QueryWebVDir = ERR_GENERAL_FAILURE
        Exit Function
    End If

    ' Semi-sync query. (flags = ForwardOnly Or ReturnImediately = &H30)
	strQuery = "ASSOCIATORS OF {IIsDirectory=""" & strPath & """} WHERE ResultClass = IIsWebVirtualDir " & _
	    "ResultRole = PartComponent"
	Set Servers = providerObj.ExecQuery(strQuery, , &H30)
	If (Err.Number <> 0) Then
		WScript.Echo L_Query_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
		QueryWebVDir = Err.Number
		Exit Function
	End If

    bFirstIteration = True
    For Each Server in Servers
        
        If Server.Name = "" Then
            WScript.Echo L_CannotGetVDir_ErrorMessage
            WScript.Echo L_CannotGetVDir2_ErrorMessage
            WScript.Echo L_CannotGetVDir3_ErrorMessage
            Exit Function
        End If

        If bFirstIteration Then
		    WScript.Echo L_AliasName_Text & Space(35 - Len(L_AliasName_Text)) & L_Path_Text
		    WScript.Echo "=============================================================================="
		End If

		Err.Clear
        Set vdirObj = providerObj.get("IIsWebVirtualDirSetting=""" & Server.Name & """")
    	If (Err.Number <> 0) Then
    		WScript.Echo L_GetSetting_ErrorMessage
            oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
    	    QueryWebVDir = Err.Number
    	    Exit Function
    	End If
    	
        ' If this is the first binding list, print server comment and server name
        strVDirName = Replace(vdirObj.Name, strPath, "") ', , , vbTextCompare)
        firstLen = 35 - Len(strVDirName)
        If (firstLen < 1) Then
            firstLen = 1
        End If

        WScript.Echo strVDirName & Space(firstLen) & vdirObj.Path
        
        bFirstIteration = False
	Next

	If bFirstIteration Then
		WScript.Echo L_VDirsNotFound_ErrorMessage
	End If

    QueryWebVDir = ERR_OK
End Function
