'
' Copyright (c) Microsoft Corporation.  All rights reserved.
'
' VBScript Source File 
'
' Script Name: IIsFtp.vbs
'

Option Explicit
On Error Resume Next

' Error codes
Const ERR_OK                         = 0
Const ERR_GENERAL_FAILURE            = 1

'''''''''''''''''''''
' Messages
Const L_BindingConflict_ErrorMessage = "(ERREUR : CONFLIT DE LIAISON)"
Const L_SitesNotFound_ErrorMessage  = "Aucun site trouv."
Const L_IsAlready_Message       = "Le serveur %1 est dj %2"
Const L_HasBeen_Message         = "Le serveur %1 a t %2"
Const L_GetAD_Message           = "La valeur de %1 pour l'utilisateur %2 est:"
Const L_SetAD_Message           = "La valeur de %1 pour l'utilisateur %2 a t dfinie  %3"

Const L_All_Text                = "Tout"
Const L_AllUnassigned_Text      = "Non assigne"
Const L_NotSpecified_Text       = "Non spcifi"
Const L_NoISO_Text              = "Aucun"

Const L_Server_Text          = "Serveur"
Const L_SiteName_Text        = "Nom du site"
Const L_MetabasePath_Message = "Chem. mtabase"
Const L_IP_Text              = "IP"
Const L_Port_Text            = "Port"
Const L_Root_Text            = "Racine"
Const L_ISO_Text             = "IsoMode"
Const L_Status_Text          = "tat"
Const L_NA_Text              = "N/A"

Const L_UnexpectedState_ErrorMessage   = "tat inattendu"
Const L_Error_ErrorMessage             = "Erreur &H%1 : %2"
Const L_GetRoot_ErrorMessage           = "Impossible d'obtenir le rpertoire virtuel racine du site"
Const L_SiteGet_ErrorMessage           = "Impossible d'obtenir le site FTP %1"
Const L_Stop_ErrorMessage              = "Impossible d'arrter le site FTP %1"
Const L_SiteDel_ErrorMessage           = "Impossible de supprimer le site FTP %1"
Const L_GetFtpServer_ErrorMessage      = "Une erreur s'est produite lors de l'obtention de l'objet FTPServer."
Const L_CannotCreateDir_ErrorMessage   = "Impossible de crer le rpertoire racine"
Const L_CmdLib_ErrorMessage            = "Impossible de crer une instance de l'objet CmdLib."
Const L_ChkCmdLibReg_ErrorMessage      = "Veuillez enregistrer le composant Microsoft.CmdLib."
Const L_DirFormat_ErrorMessage         = "Format du rpertoire racine inconnu. Utiliser le format"
Const L_DirFormat2_ErrorMessage        = "'<lecteur>:\<chemin>'."
Const L_CannotStart_Message            = "%1: le serveur ne peut pas tre dmarr dans son tat actuel"
Const L_CannotStart2_Message           = "(le serveur %1 est %2)"
Const L_CannotStop_Message             = "Le serveur ne peut pas tre arrt dans son tat actuel"
Const L_CannotStop2_Message            = "(le serveur %1 est %2)"
Const L_CannotPause_Message            = "Le serveur ne peut pas tre suspendu dans son tat actuel"
Const L_CannotPause2_Message           = "(le serveur %1 est %2)"
Const L_CannotControl_ErrorMessage     = "Le serveur ne peut pas tre contrl dans son tat actuel"
Const L_FailChange_ErrorMessage        = "Impossible de modifier le statut du serveur %1"
Const L_OperationRequired_ErrorMessage = "Spcifier une opration avant les arguments."
Const L_MinInfoNeeded_ErrorMessage     = "Ncessite au moins une racine pour crer un site."
Const L_NotEnoughParams_ErrorMessage   = "Paramtres insuffisants."
Const L_Query_ErrorMessage             = "Une erreur s'est produite lors d'une requte auprs du fournisseur WMI."
Const L_OnlyOneOper_ErrorMessage       = "Spcifier une opration en un temps donn."
Const L_ServerInstance_ErrorMessage    = "Une erreur s'est produite lors de la cration d'un nouvelle instance de serveur FTP."
Const L_ServerPut_ErrorMessage         = "Une erreur s'est produite lors de la tentative de sauvegarde d'une nouvelle instance de serveur FTP."
Const L_VDirInstance_ErrorMessage      = "Une erreur s'est produite lors de la cration d'une nouvelle instance de rpertoire virtuel."
Const L_VDirPut_ErrorMessage           = "Une erreur s'est produite lors de la sauvegarde d'une nouvelle instance de rpertoire virtuel."
Const L_ScriptHelper_ErrorMessage      = "Impossible de crer une instance de l'objet IIsScriptHelper."
Const L_ChkScpHelperReg_ErrorMessage   = "Veuillez enregistrer le composant Microsoft.IIsScriptHelper."
Const L_InvalidIP_ErrorMessage         = "Adresse IP non valide. Vrifiez qu'elle est bien formate et"
Const L_InvalidIP2_ErrorMessage        = "appartient  cet ordinateur."
Const L_InvalidPort_ErrorMessage       = "Numro de port non valide."
Const L_InvalidArg_ErrorMessage        = "Argument non valide : %1"
Const L_MapDrive_ErrorMessage          = "Impossible de mapper le lecteur rseau."
Const L_PassWithoutUser_ErrorMessage   = "Spcifier le commutateur /u avant /p."
Const L_WMIConnect_ErrorMessage        = "Impossible de se connecter au fournisseur WMI."
Const L_InvalidSwitch_ErrorMessage     = "Commutateur non valide : %1"
Const L_Admin_ErrorMessage             = "Vous ne pouvez pas excuter cette commande car vous n'tes pas"
Const L_Admin2_ErrorMessage            = "un administrateur sur le serveur que vous essayez de configurer."
Const L_ADUserNotFound_ErrorMessage    = "L'utilisateur %1 est introuvable dans Active Directory."

'''''''''''''''''''''
' Help

' General help messages
Const L_SeeHelp_Message       = "Entrez IIsFtp /? pour afficher l'aide."
Const L_SeeStartHelp_Message  = "Entrez IIsFtp /start /? pour afficher l'aide."
Const L_SeeStopHelp_Message   = "Entrez IIsFtp /stop /? pour afficher l'aide."
Const L_SeePauseHelp_Message  = "Entrez IIsFtp /pause /? pour afficher l'aide."
Const L_SeeCreateHelp_Message = "Entrez IIsFtp /create /? pour afficher l'aide."
Const L_SeeDeleteHelp_Message = "Entrez IIsFtp /delete /? pour afficher l'aide."
Const L_SeeGetADPropHelp_Message = "Entrez IIsFtp /getadprop /? pour afficher l'aide."
Const L_SeeSetADPropHelp_Message = "Entrez IIsFtp /setadprop /? pour afficher l'aide."
Const L_SeeQueryHelp_Message  = "Entrez IIsFtp /query /? pour afficher l'aide."


Const L_Help_HELP_General01_Text  = "Description: dmarre, arrte, suspend, supprime, effectue une requte ou cre"
Const L_Help_HELP_General01a_Text = "              un site FTP"
Const L_Help_HELP_General02_Text  = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_de_passe>]]]"
Const L_Help_HELP_General03_Text  = "        /<opration> [arguments]"
Const L_Help_HELP_General04_Text  = "Paramtres :"
Const L_Help_HELP_General05_Text  = ""
Const L_Help_HELP_General06_Text  = "Valeur                  Description"
Const L_Help_HELP_General07_Text  = "/s <serveur>            Connecter  l'ordinateur <serveur>"
Const L_Help_HELP_General07a_Text = "                        [Par dfaut: ce systme]"
Const L_Help_HELP_General08_Text  = "/u <utilisateur>        Connecter en tant que <domaine>\<utilisateur> ou"
Const L_Help_HELP_General09_Text  = "                        <nom_utilisateur> [Par dfaut: l'utilisateur actuel]"
Const L_Help_HELP_General10_Text  = "/p <mot_passe>          Mot de passe de l'utilisateur <nom_utilisateur>"
Const L_Help_HELP_General11_Text  = "<opration>             /start      Dmarre un site sur le"
Const L_Help_HELP_General11a_Text = "                                    serveur IIS donn."
Const L_Help_HELP_General12_Text  = "                        /stop       Arrte l'excution d'un site"
Const L_Help_HELP_General13_Text  = "                                    sur un serveur IIS"
Const L_Help_HELP_General13a_Text = "                                    donn."
Const L_Help_HELP_General14_Text  = "                        /pause      Suspend un site"
Const L_Help_HELP_General15_Text  = "                                    en cours d'excution sur un serveur IIS"
Const L_Help_HELP_General15a_Text = "                                    donn."
Const L_Help_HELP_General18_Text  = "                        /delete     Supprime le configuration IIS d'un site"
Const L_Help_HELP_General19_Text  = "                                    FTP existant."
Const L_Help_HELP_General19a_Text = "                                    Le contenu ne sera pas"
Const L_Help_HELP_General19b_Text = "                                    supprim."
Const L_Help_HELP_General20_Text  = "                        /create     Cre un site FTP."
Const L_Help_HELP_General21_Text  = "                        /query      Effectue des requtes sur des sites FTP."
Const L_Help_HELP_General21a_Text = "                        /SetADProp  Dfinit les valeurs FTPRoot et FTPDir"
Const L_Help_HELP_General21b_Text = "                                    dans Active Directory."
Const L_Help_HELP_General21c_Text = "                        /GetADProp  Effectue des requtes des valeurs FTPRoot et FTPDir"
Const L_Help_HELP_General21d_Text = "                                     partir d'Active Directory."
Const L_Help_HELP_General22_Text  = "Pour une utilisation dtaille :"
Const L_Help_HELP_General23_Text  = "IIsFtp /start /?"
Const L_Help_HELP_General24_Text  = "IIsFtp /stop /?"
Const L_Help_HELP_General25_Text  = "IIsFtp /pause /?"
Const L_Help_HELP_General27_Text  = "IIsFtp /delete /?"
Const L_Help_HELP_General28_Text  = "IIsFtp /create /?"
Const L_Help_HELP_General29_Text  = "IIsFtp /query /?"
Const L_Help_HELP_General30_Text  = "IIsFtp /SetADProp /?"
Const L_Help_HELP_General31_Text  = "IIsFtp /GetADProp /?"

' Common to all status change commands
Const L_Help_HELP_Status03_Text   = "Paramtres :"
Const L_Help_HELP_Status09_Text   = "<site_FTP>              Utiliser le nom du site ou le chemin d'accs de la mtabase"
Const L_Help_HELP_Status09p1_Text = "                        pour spcifier le site"
Const L_Help_HELP_Status10_Text   = "Exemples:"

' Start help messages
Const L_Help_HELP_Start01_Text   = "Description: dmarre des sites sur un serveur IIS donn."
Const L_Help_HELP_Start02_Text   = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_de_passe>]]]"
Const L_Help_HELP_Start02p1_Text = "        /start <site_FTP> [<site_FTP> ...]"
Const L_Help_HELP_Start11_Text   = "IIsFtp /start ""Site FTP par dfaut"""
Const L_Help_HELP_Start12_Text   = "IIsFtp /start msftpsvc/1"
Const L_Help_HELP_Start13_Text   = "IIsFtp /start w3svc/2 ""Site FTP par dfaut"" w3svc/10"
Const L_Help_HELP_Start14_Text   = "IIsFtp /s Serveur1 /u Administrateur /p m0t_p@sSe /start msftpsvc/4"

' Stop help messages
Const L_Help_HELP_Stop01_Text   = "Description: arrte des sites sur un serveur IIS donn."
Const L_Help_HELP_Stop02_Text   = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]] /stop"
Const L_Help_HELP_Stop02p1_Text = "        <site_FTP> [<site_FTP> ...]"
Const L_Help_HELP_Stop11_Text   = "IIsFtp /stop ""Site FTP par dfaut"""
Const L_Help_HELP_Stop12_Text   = "IIsFtp /stop msftpsvc/1"
Const L_Help_HELP_Stop13_Text   = "IIsFtp /stop w3svc/2 ""Site FTP par dfaut"" w3svc/10"
Const L_Help_HELP_Stop14_Text   = "IIsFtp /s Serveur1 /u Administrateur /p m0t_p@sSe /stop msftpsvc/4"

' GetADProp help messages
Const L_Help_HELP_GetADProp01_Text   = "Description: effectue des requtes des proprits  partir d'Active Directory."
Const L_Help_HELP_GetADProp02_Text   = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]]"
Const L_Help_HELP_GetADProp02p1_Text = "        /GetADProp <ID_utilisateur> FTPDir | FTPRoot"
Const L_Help_HELP_GetADProp10_Text   = "<ID_utilisateur>        L'ID d'ouverture de session de l'utilisateur Active Directory"
Const L_Help_HELP_GetADProp10a_Text  = "                         partir duquel la proprit est rcupre."
Const L_Help_HELP_GetADProp11_Text   = "IIsFtp /GetADProp pauldurand FTPDir"
Const L_Help_HELP_GetADProp12_Text   = "IIsFtp /GetADProp mariedurand FTPRoot"

' SetADProp help messages
Const L_Help_HELP_SetADProp01_Text   = "Description: dfinit les proprits dans Active Directory."
Const L_Help_HELP_SetADProp02_Text   = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]]"
Const L_Help_HELP_SetADProp02p1_Text = "        /SetADProp <ID_utilisateur> FTPDir | FTPRoot <val_prop>"
Const L_Help_HELP_SetADProp10_Text   = "<ID_utilisateur>        L'ID d'ouverture de session de l'utilisateur Active Directory"
Const L_Help_HELP_SetADProp10a_Text  = "                        pour lequel la proprit sera dfinie."
Const L_Help_HELP_SetADProp11_Text   = "IIsFtp /SetADProp pauldurand FTPDir pauldossier"
Const L_Help_HELP_SetADProp12_Text   = "IIsFtp /SetADProp mariedurand FTPRoot c:\toto"

' Pause help messages
Const L_Help_HELP_Pause01_Text   = "Description: suspend des sites sur un serveur IIS donn."
Const L_Help_HELP_Pause02_Text   = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]]"
Const L_Help_HELP_Pause02p1_Text = "        /pause <site_FTP> [<site_FTP> ...]"
Const L_Help_HELP_Pause11_Text   = "IIsFtp /pause ""Site FTP par dfaut"""
Const L_Help_HELP_Pause12_Text   = "IIsFtp /pause msftpsvc/1"
Const L_Help_HELP_Pause13_Text   = "IIsFtp /pause w3svc/2 ""Site FTP par dfaut"" w3svc/10"
Const L_Help_HELP_Pause14_Text   = "IIsFtp /s Serveur1 /u Administrateur /p m0t_p@sSe /pause msftpsvc/4"

' Delete help messages
Const L_Help_HELP_Delete01_Text   = "Description: supprime la configuration IIS pour un site"
Const L_Help_HELP_Delete01p1_Text = "              FTP existant. Le contenu ne sera pas supprim."
Const L_Help_HELP_Delete02_Text   = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]]"
Const L_Help_HELP_Delete02p1_Text = "        /delete <site_FTP> [<site_FTP> ...]"
Const L_Help_HELP_Delete11_Text   = "IIsFtp /delete ""Site FTP par dfaut"""
Const L_Help_HELP_Delete12_Text   = "IIsFtp /delete msftpsvc/1"
Const L_Help_HELP_Delete13_Text    = "IIsFtp /delete w3svc/2 ""Site FTP par dfaut"" w3svc/10"
Const L_Help_HELP_Delete14_Text   = "IIsFtp /s Serveur1 /u Administrateur /p m0t_p@sSe /delete msftpsvc/4"

' Create help messages
Const L_Help_HELP_Create01_Text   = "Description: cre un site FTP."
Const L_Help_HELP_Create02_Text   = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]]"
Const L_Help_HELP_Create02p1_Text = "        /create <racine> <nom> [/b <port>] [/i <ip>] [/dontstart]"
Const L_Help_HELP_Create03_Text   = "        [/isolation <mode_iso> [/ADDomain <domaine>"
Const L_Help_HELP_Create03a_Text  = "        /ADAdmin <admin> /ADPass <mot_passe>]]"
Const L_Help_HELP_Create09_Text   = "<racine>                Rpertoire racine pour le nouveau serveur."
Const L_Help_HELP_Create09p1_Text = "                        Si ce rpertoire n'existe pas,"
Const L_Help_HELP_Create09p2_Text = "                        il sera cr."
Const L_Help_HELP_Create10_Text   = "<nom>                   Le nom qui apparat dans"
Const L_Help_HELP_Create10p1_Text = "                        Microsoft Management Console (MMC)."
Const L_Help_HELP_Create12_Text   = "/b <port>               Le numro du port auquel le"
Const L_Help_HELP_Create12p1_Text = "                        nouveau serveur devrait se lier. [Par dfaut: 21]"
Const L_Help_HELP_Create13_Text   = "/i <ip>                 L'adresse IP  assigner au nouveau"
Const L_Help_HELP_Create13p1_Text = "                        serveur. [Par dfaut: tout non assign]"
Const L_Help_HELP_Create15_Text   = "/dontstart              Ne pas dmarrer pas ce site aprs sa cration."
Const L_Help_HELP_Create16_Text   = "/isolation              Dfinir le mode d'isolation  Local ou AD."
Const L_Help_HELP_Create17_Text   = "/AD*                    Dfinit les informations d'identification d'Active Directory pour"
Const L_Help_HELP_Create17a_Text  = "                        le mode d'isolation AD."
Const L_Help_HELP_Create22_Text   = "IIsFtp /create c:\inetpub\ftproot ""Mon Site"" /b 21"
Const L_Help_HELP_Create23_Text   = "IIsFtp /s Serveur1 /u Administrateur /p m0t_p@sSe /create c:\inetpub\ftproot"
Const L_Help_HELP_Create23p1_Text = "       ""Mon Site"""
Const L_Help_HELP_Create24_Text   = "IIsFtp /create c:\inetpub\ftproot ""Mon Site"" /i 172.30.163.244 /b 21"

' Query help messages
Const L_Help_HELP_Query01_Text   = "Description: effectue des requtes sur des sites FTP."
Const L_Help_HELP_Query02_Text   = "Syntaxe: IIsFtp [/s <serveur> [/u <nom_utilisateur> [/p <mot_passe>]]]"
Const L_Help_HELP_Query02p1_Text = "        /query [<site_FTP> ...]"
Const L_Help_HELP_Query11_Text   = "IIsFtp /query ""Site FTP par dfaut"""
Const L_Help_HELP_Query12_Text   = "IIsFtp /query msftpsvc/1"
Const L_Help_HELP_Query13_Text   = "IIsFtp /query"
Const L_Help_HELP_Query14_Text   = "IIsFtp /query ""Site FTP par dfaut"" ""Site chantillon"" msftpsvc/1"
Const L_Help_HELP_Query15_Text   = "IIsFtp /s Serveur1 /u Administrateur /p m0t_p@sSe /query ""Site FTP par dfaut"""

' Status
Const L_Started_Text   = "dmarr"
Const L_Stopped_Text   = "arrt"
Const L_Paused_Text    = "en pause"
Const L_Continued_Text = "continu"
Const L_Deleted_Text   = "supprim"

''''''''''''''''''''''''
Dim SiteStatus
SiteStatus = Array("", "", L_Started_Text, "", L_Stopped_Text, "", L_Paused_Text, L_Continued_Text, L_Deleted_Text)

' Operation codes
Const OPER_START    = 1
Const OPER_STOP     = 2
Const OPER_PAUSE    = 3
Const OPER_DELETE   = 4
Const OPER_CREATE   = 5
Const OPER_QUERY    = 6
Const OPER_GETADPROP= 7
Const OPER_SETADPROP= 8

' ServerState codes
Const SERVER_STARTING   = 1
Const SERVER_STARTED    = 2
Const SERVER_STOPPING   = 3
Const SERVER_STOPPED    = 4
Const SERVER_PAUSING    = 5
Const SERVER_PAUSED     = 6
Const SERVER_CONTINUING = 7

'
' Main block
'
Dim oScriptHelper, oCmdLib
Dim strServer, strUser, strPassword, strSite
Dim intOperation, intResult
Dim strRoot, strName, strPort, strIP, strISO, strADDomain, strADAdmin, strADPass
Dim bDontStart
Dim aArgs, arg
Dim strCmdLineOptions
Dim oError

' Default values
strServer = "."
strUser = ""
strPassword = ""
intOperation = 0
strSite = ""
strName = ""
bDontStart = False

' Instantiate the CmdLib for output string formatting
Set oCmdLib = CreateObject("Microsoft.CmdLib")
If Err.Number <> 0 Then
    WScript.Echo L_CmdLib_ErrorMessage
    WScript.Echo L_ChkCmdLibReg_ErrorMessage    
    WScript.Quit(ERR_GENERAL_FAILURE)
End If
Set oCmdLib.ScriptingHost = WScript.Application

' Instantiate script helper object
Set oScriptHelper = CreateObject("Microsoft.IIsScriptHelper")
If Err.Number <> 0 Then
    WScript.Echo L_ScriptHelper_ErrorMessage
    WScript.Echo L_ChkScpHelperReg_ErrorMessage    
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

Set oScriptHelper.ScriptHost = WScript

' Check if we are being run with cscript.exe instead of wscript.exe
oScriptHelper.CheckScriptEngine

' Minimum number of parameters must exist
If WScript.Arguments.Count < 1 Then
    WScript.Echo L_NotEnoughParams_ErrorMessage
    WScript.Echo L_SeeHelp_Message
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

strCmdLineOptions = "[server:s:1;user:u:1;password:p:1];start::n;stop::n;pause::n;delete::n;" & _
                    "[create:c:1;port:b:1;ip:i:1;dontstart::0;isolation::1;addomain::1;adadmin::1;adpass::1];query:q:n;" & _
                    "getadprop::n;setadprop::n"

Set oError = oScriptHelper.ParseCmdLineOptions(strCmdLineOptions)

If Not oError Is Nothing Then
    If oError.ErrorCode = oScriptHelper.ERROR_NOT_ENOUGH_ARGS Then
        ' Not enough arguments for a specified switch
        WScript.Echo L_NotEnoughParams_ErrorMessage
        If oError.SwitchName = "create" Then
            WScript.Echo L_SeeCreateHelp_Message
        Else
            WScript.Echo L_SeeHelp_Message
        End If
    Else
        ' Invalid switch
        oCmdLib.vbPrintf L_InvalidSwitch_ErrorMessage, Array(oError.SwitchName)
        WScript.Echo L_SeeHelp_Message
    End If
        
        WScript.Quit(ERR_GENERAL_FAILURE)
End If

If oScriptHelper.GlobalHelpRequested Then
    DisplayHelpMessage
    WScript.Quit(ERR_OK)
End If

For Each arg In oScriptHelper.Switches
    Select Case arg
        Case "server"
            ' Server information
            strServer = oScriptHelper.GetSwitch(arg)

        Case "user"
            ' User information
            strUser = oScriptHelper.GetSwitch(arg)

        Case "password"
            ' Password information
            strPassword = oScriptHelper.GetSwitch(arg)
        
        Case "start"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

            intOperation = OPER_START
            
            If oScriptHelper.IsHelpRequested(arg) Then
                DisplayStartHelpMessage
                WScript.Quit(ERR_OK)
            End If

            aArgs = oScriptHelper.GetSwitch(arg)

            If UBound(aArgs) = -1 Then
                WScript.Echo L_NotEnoughParams_ErrorMessage
                WScript.Echo L_SeeStartHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

        Case "stop"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

            intOperation = OPER_STOP
            
            If oScriptHelper.IsHelpRequested(arg) Then
                DisplayStopHelpMessage
                WScript.Quit(ERR_OK)
            End If

            aArgs = oScriptHelper.GetSwitch(arg)
        
            If UBound(aArgs) = -1 Then
                WScript.Echo L_NotEnoughParams_ErrorMessage
                WScript.Echo L_SeeStopHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

        Case "pause"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

            intOperation = OPER_PAUSE
                        
            If oScriptHelper.IsHelpRequested(arg) Then
                DisplayPauseHelpMessage
                WScript.Quit(ERR_OK)
            End If

            aArgs = oScriptHelper.GetSwitch(arg)
        
            If UBound(aArgs) = -1 Then
                WScript.Echo L_NotEnoughParams_ErrorMessage
                WScript.Echo L_SeePauseHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

        Case "create"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

            intOperation = OPER_CREATE

            If oScriptHelper.IsHelpRequested(arg) Then
                DisplayCreateHelpMessage
                WScript.Quit(ERR_OK)
            End If

            strRoot = oScriptHelper.GetSwitch(arg)
            aArgs = oScriptHelper.NamedArguments

            If strRoot = "" Or UBound(aArgs) = -1 Then
                WScript.Echo L_NotEnoughParams_ErrorMessage
                WScript.Echo L_SeeCreateHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

            strName    = aArgs(0)
            strPort    = oScriptHelper.GetSwitch("port")
            strIP      = oScriptHelper.GetSwitch("ip")
            If oScriptHelper.Switches.Exists("dontstart") Then
                bDontStart = True
            End If

            strISO     = oScriptHelper.GetSwitch("isolation")
            strADDomain= oScriptHelper.GetSwitch("addomain")
            strADAdmin = oScriptHelper.GetSwitch("adadmin")
            strADPass  = oScriptHelper.GetSwitch("adpass")

            If UCase(strISO) = "AD" Then
                strRoot = ""
            End If

        Case "delete"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If
        
            intOperation = OPER_DELETE

            If oScriptHelper.IsHelpRequested(arg) Then
                DisplayDeleteHelpMessage
                WScript.Quit(ERR_OK)
            End If

            aArgs = oScriptHelper.GetSwitch(arg)
            
            If UBound(aArgs) = -1 Then
                WScript.Echo L_NotEnoughParams_ErrorMessage
                WScript.Echo L_SeeDeleteHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If
        
        Case "query"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If
        
            intOperation = OPER_QUERY

            If oScriptHelper.IsHelpRequested(arg) Then
                DisplayQueryHelpMessage
                WScript.Quit(ERR_OK)
            End If

            aArgs = oScriptHelper.GetSwitch(arg)

        Case "getadprop"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If
        
            intOperation = OPER_GETADPROP

            If oScriptHelper.IsHelpRequested(arg) Then
                DisplayGetADPropHelpMessage
                WScript.Quit(ERR_OK)
            End If

            aArgs = oScriptHelper.GetSwitch(arg)
            
            If UBound(aArgs) = -1 Then
                WScript.Echo L_NotEnoughParams_ErrorMessage
                WScript.Echo L_SeeGetADPropHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

        Case "setadprop"
            If (intOperation <> 0) Then
                WScript.Echo L_OnlyOneOper_ErrorMessage
                WScript.Echo L_SeeHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If
        
            intOperation = OPER_SETADPROP

            If oScriptHelper.IsHelpRequested(arg) Then
                DisplaySetADPropHelpMessage
                WScript.Quit(ERR_OK)
            End If

            aArgs = oScriptHelper.GetSwitch(arg)
            
            If UBound(aArgs) = -1 Then
                WScript.Echo L_NotEnoughParams_ErrorMessage
                WScript.Echo L_SeeSetADPropHelp_Message
                WScript.Quit(ERR_GENERAL_FAILURE)
            End If

    End Select
Next

' Check Parameters
If intOperation = 0 Then
    WScript.Echo L_OperationRequired_ErrorMessage
    WScript.Echo L_SeeHelp_Message
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

' Check if /p is specified but /u isn't. In this case, we should bail out with an error
If oScriptHelper.Switches.Exists("password") And Not oScriptHelper.Switches.Exists("user") Then
    WScript.Echo L_PassWithoutUser_ErrorMessage
    WScript.Quit(ERR_GENERAL_FAILURE)
End If

' Check if /u is specified but /p isn't. In this case, we should ask for a password
If oScriptHelper.Switches.Exists("user") And Not oScriptHelper.Switches.Exists("password") Then
    strPassword = oCmdLib.GetPassword
End If

' Initializes authentication with remote machine 
' This initialization applies only for IIS operations. We skip it for AD operations
If intOperation <> OPER_GETADPROP And intOperation <> OPER_SETADPROP Then
    intResult = oScriptHelper.InitAuthentication(strServer, strUser, strPassword)
    If intResult <> 0 Then
        WScript.Quit(intResult)
    End If
End If

' Choose operation
Select Case intOperation
    Case OPER_START
        intResult = ChangeFtpSiteStatus(aArgs, SERVER_STARTED)
        
    Case OPER_STOP
        intResult = ChangeFtpSiteStatus(aArgs, SERVER_STOPPED)

    Case OPER_PAUSE
        intResult = ChangeFtpSiteStatus(aArgs, SERVER_PAUSED)

    Case OPER_DELETE
        intResult = DeleteFtpSite(aArgs)

    Case OPER_CREATE
        intResult = CreateFtpSite(strRoot, strName, strPort, strIP, bDontStart, strISO, strADDomain, strADAdmin, strADPass)

    Case OPER_QUERY
        intResult = QueryFtpSite(aArgs)

    Case OPER_GETADPROP
        intResult = GetADProp(strServer, strUser, strPassword, aArgs)

    Case OPER_SETADPROP
        intResult = SetADProp(strServer, strUser, strPassword, aArgs)

End Select

' Return value to command processor
WScript.Quit(intResult)

'''''''''''''''''''''''''
' End Of Main Block
'''''''''''''''''''''

'''''''''''''''''''''''''''
' DisplayHelpMessage
'''''''''''''''''''''''''''
Sub DisplayHelpMessage()
    WScript.Echo L_Help_HELP_General01_Text
    WScript.Echo L_Help_HELP_General01a_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General02_Text
    WScript.Echo L_Help_HELP_General03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General04_Text
    WScript.Echo L_Help_HELP_General05_Text
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_General11_Text
    WScript.Echo L_Help_HELP_General11a_Text
    WScript.Echo L_Help_HELP_General12_Text
    WScript.Echo L_Help_HELP_General13_Text
    WScript.Echo L_Help_HELP_General13a_Text
    WScript.Echo L_Help_HELP_General14_Text
    WScript.Echo L_Help_HELP_General15_Text
    WScript.Echo L_Help_HELP_General15a_Text
    WScript.Echo L_Help_HELP_General18_Text
    WScript.Echo L_Help_HELP_General19_Text
    WScript.Echo L_Help_HELP_General19a_Text
    WScript.Echo L_Help_HELP_General19b_Text
    WScript.Echo L_Help_HELP_General20_Text
    WScript.Echo L_Help_HELP_General21_Text
    WScript.Echo L_Help_HELP_General21a_Text
    WScript.Echo L_Help_HELP_General21b_Text
    WScript.Echo L_Help_HELP_General21c_Text
    WScript.Echo L_Help_HELP_General21d_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General22_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General23_Text
    WScript.Echo L_Help_HELP_General24_Text
    WScript.Echo L_Help_HELP_General25_Text
    WScript.Echo L_Help_HELP_General27_Text
    WScript.Echo L_Help_HELP_General28_Text
    WScript.Echo L_Help_HELP_General29_Text
    WScript.Echo L_Help_HELP_General30_Text
    WScript.Echo L_Help_HELP_General31_Text
End Sub

Sub DisplayStartHelpMessage()
    WScript.Echo L_Help_HELP_Start01_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Start02_Text
    WScript.Echo L_Help_HELP_Start02p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Status09_Text
    WScript.Echo L_Help_HELP_Status09p1_Text
    WScript.Echo 
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status10_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Start11_Text
    WScript.Echo L_Help_HELP_Start12_Text
    WScript.Echo L_Help_HELP_Start13_Text
    WScript.Echo L_Help_HELP_Start14_Text
End Sub

Sub DisplayStopHelpMessage()
    WScript.Echo L_Help_HELP_Stop01_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Stop02_Text
    WScript.Echo L_Help_HELP_Stop02p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Status09_Text
    WScript.Echo L_Help_HELP_Status09p1_Text
    WScript.Echo 
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status10_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Stop11_Text
    WScript.Echo L_Help_HELP_Stop12_Text
    WScript.Echo L_Help_HELP_Stop13_Text
    WScript.Echo L_Help_HELP_Stop14_Text
End Sub

Sub DisplayGetADPropHelpMessage()
    WScript.Echo L_Help_HELP_GetADProp01_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_GetADProp02_Text
    WScript.Echo L_Help_HELP_GetADProp02p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_GetADProp10_Text
    WScript.Echo L_Help_HELP_GetADProp10a_Text
    WScript.Echo 
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status10_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_GetADProp11_Text
    WScript.Echo L_Help_HELP_GetADProp12_Text
End Sub

Sub DisplaySetADPropHelpMessage()
    WScript.Echo L_Help_HELP_SetADProp01_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_SetADProp02_Text
    WScript.Echo L_Help_HELP_SetADProp02p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_SetADProp10_Text
    WScript.Echo L_Help_HELP_SetADProp10a_Text
    WScript.Echo 
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status10_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_SetADProp11_Text
    WScript.Echo L_Help_HELP_SetADProp12_Text
End Sub

Sub DisplayPauseHelpMessage()
    WScript.Echo L_Help_HELP_Pause01_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Pause02_Text
    WScript.Echo L_Help_HELP_Pause02p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Status09_Text
    WScript.Echo L_Help_HELP_Status09p1_Text
    WScript.Echo 
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status10_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Pause11_Text
    WScript.Echo L_Help_HELP_Pause12_Text
    WScript.Echo L_Help_HELP_Pause13_Text
    WScript.Echo L_Help_HELP_Pause14_Text
End Sub

Sub DisplayDeleteHelpMessage()
    WScript.Echo L_Help_HELP_Delete01_Text
    WScript.Echo L_Help_HELP_Delete01p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Delete02_Text
    WScript.Echo L_Help_HELP_Delete02p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Status09_Text
    WScript.Echo L_Help_HELP_Status09p1_Text
    WScript.Echo 
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status10_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Delete11_Text
    WScript.Echo L_Help_HELP_Delete12_Text
    WScript.Echo L_Help_HELP_Delete13_Text
    WScript.Echo L_Help_HELP_Delete14_Text
End Sub

Sub DisplayCreateHelpMessage()
    WScript.Echo L_Help_HELP_Create01_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Create02_Text
    WScript.Echo L_Help_HELP_Create02p1_Text
    WScript.Echo L_Help_HELP_Create03_Text
    WScript.Echo L_Help_HELP_Create03a_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Create09_Text
    WScript.Echo L_Help_HELP_Create09p1_Text
    WScript.Echo L_Help_HELP_Create09p2_Text
    WScript.Echo L_Help_HELP_Create10_Text
    WScript.Echo L_Help_HELP_Create10p1_Text
    WScript.Echo L_Help_HELP_Create12_Text
    WScript.Echo L_Help_HELP_Create12p1_Text
    WScript.Echo L_Help_HELP_Create13_Text
    WScript.Echo L_Help_HELP_Create13p1_Text
    WScript.Echo L_Help_HELP_Create15_Text
    WScript.Echo L_Help_HELP_Create16_Text
    WScript.Echo L_Help_HELP_Create17_Text
    WScript.Echo L_Help_HELP_Create17a_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status10_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Create22_Text
    WScript.Echo L_Help_HELP_Create23_Text
    WScript.Echo L_Help_HELP_Create23p1_Text
    WScript.Echo L_Help_HELP_Create24_Text
End Sub

Sub DisplayQueryHelpMessage()
    WScript.Echo L_Help_HELP_Query01_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Query02_Text
    WScript.Echo L_Help_HELP_Query02p1_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status03_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_General06_Text
    WScript.Echo L_Help_HELP_General07_Text
    WScript.Echo L_Help_HELP_General07a_Text
    WScript.Echo L_Help_HELP_General08_Text
    WScript.Echo L_Help_HELP_General09_Text
    WScript.Echo L_Help_HELP_General10_Text
    WScript.Echo L_Help_HELP_Status09_Text
    WScript.Echo L_Help_HELP_Status09p1_Text
    WScript.Echo 
    WScript.Echo 
    WScript.Echo L_Help_HELP_Status10_Text
    WScript.Echo 
    WScript.Echo L_Help_HELP_Query11_Text
    WScript.Echo L_Help_HELP_Query12_Text
    WScript.Echo L_Help_HELP_Query13_Text
    WScript.Echo L_Help_HELP_Query14_Text
    WScript.Echo L_Help_HELP_Query15_Text
End Sub


'''''''''''''''''''''''''''
' ChangeFtpSiteStatus
'
' Try to change the status of a site 
' to the one specified 
'''''''''''''''''''''''''''
Function ChangeFtpSiteStatus(aArgs, newStatus)
    Dim Server, strSiteName
    Dim intResult, i, intNewStatus
    Dim aSites
    Dim providerObj, ServiceObj
    Dim bNonFatalError

    On Error Resume Next

    bNonFatalError = False

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        ChangeFtpSiteStatus = Err.Number
        Exit Function
    End If
    
    Set providerObj = oScriptHelper.ProviderObj
    intResult = 0

    ' Quick check to see if we have permission
    Set ServiceObj = providerObj.Get("IIsFtpService='MSFTPSVC'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Admin2_ErrorMessage

            Case Else
                WScript.Echo Err.Description
        End Select
        
        ChangeFtpSiteStatus = Err.Number
        Exit Function
    End If

    aSites = oScriptHelper.FindSite("Ftp", aArgs)
    If IsArray(aSites) Then
        If UBound(aSites) = -1 Then
            WScript.Echo L_SitesNotFound_ErrorMessage
            intResult = ERR_GENERAL_FAILURE
        End If
    Else
        ' Got duplicate sites. We should quit.
        ChangeFtpSiteStatus = intResult
        Exit Function
    End If
    
    For i = LBound(aSites) to UBound(aSites)

        bNonFatalError = False

        strSiteName = aSites(i)
    
        ' Grab site state before trying to start it
        Set Server = providerObj.Get("IIsFtpServer='" & strSiteName & "'")
        If (Err.Number <> 0) Then
            WScript.Echo L_GetFtpServer_ErrorMessage
            oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
            intResult = Err.Number
        End If
        
        If (Server.ServerState = newStatus) Then
            oCmdLib.vbPrintf L_IsAlready_Message, Array(strSiteName, UCase(SiteStatus(newStatus)))
        Else 
            If (Server.ServerState = SERVER_STARTING or Server.ServerState = SERVER_STOPPING or _
                Server.ServerState = SERVER_PAUSING or Server.ServerState = SERVER_CONTINUING) Then
                
                WScript.Echo L_CannotControl_ErrorMessage
                intResult = ERR_GENERAL_FAILURE
            Else
            
                Select Case newStatus
                    Case SERVER_STARTED
                        If (Server.ServerState = SERVER_STOPPED) Then
                            intNewStatus = SERVER_STARTED
                            Server.Start
                        Else 
                            If (Server.ServerState = SERVER_PAUSED) Then
                                intNewStatus = SERVER_CONTINUING
                                Server.Continue
                            Else
                                oCmdLib.vbPrintf L_CannotStart_Message, Array(strSiteName)
                                oCmdLib.vbPrintf L_CannotStart2_Message, Array(strSiteName, SiteStatus(Server.ServerState))
                                bNonFatalError = True
                            End If
                        End If
                        
                    Case SERVER_STOPPED
                        If (Server.ServerState = SERVER_STARTED) Then
                            intNewStatus = SERVER_STOPPED
                            Server.Stop
                        Else
                            WScript.Echo L_CannotStop_Message
                            oCmdLib.vbPrintf L_CannotStop2_Message, Array(strSiteName, SiteStatus(Server.ServerState))
                            bNonFatalError = True
                        End If
                    
                    Case SERVER_PAUSED
                        If (Server.ServerState = SERVER_STARTED) Then
                            intNewStatus = SERVER_PAUSED
                            Server.Pause
                        Else
                            WScript.Echo L_CannotPause_Message
                            oCmdLib.vbPrintf L_CannotPause2_Message, Array(strSiteName, SiteStatus(Server.ServerState))
                            bNonFatalError = True
                        End If
                    
                    Case Else
                        WScript.Echo L_UnexpectedState_ErrorMessage
                        WScript.Quit(ERR_GENERAL_FAILURE)

                End Select
                
                ' Error checking
                If (Err.Number <> 0) Then
                    oCmdLib.vbPrintf L_FailChange_ErrorMessage, Array(strSite)
                    oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
                    intResult = Err.Number
                Else
                    If (bNonFatalError = False) Then
                        oCmdLib.vbPrintf L_HasBeen_Message, Array(strSiteName, UCase(SiteStatus(intNewStatus)))
                    End If
                End If
            End If	
        End If
            
    Next
 
    Set Server = Nothing
    
    ChangeFtpSiteStatus = intResult
End Function


'''''''''''''''''''''''''''
' DeleteFtpSite
'''''''''''''''''''''''''''
Function DeleteFtpSite(aArgs)
    Dim strSiteName
    Dim RootVDirObj, FtpServerObj
    Dim aSites
    Dim providerObj, ServiceObj
    
    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        DeleteFtpSite = Err.Number
        Exit Function
    End If

    Set providerObj = oScriptHelper.ProviderObj

    ' Quick check to see if we have permission
    Set ServiceObj = providerObj.Get("IIsFtpService='MSFTPSVC'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Admin2_ErrorMessage

            Case Else
                WScript.Echo Err.Description
        End Select
        
        DeleteFtpSite = Err.Number
        Exit Function
    End If

    aSites = oScriptHelper.FindSite("Ftp", aArgs)
    If IsArray(aSites) Then
        If UBound(aSites) = -1 Then
            WScript.Echo L_SitesNotFound_ErrorMessage
            intResult = ERR_GENERAL_FAILURE
        End If
    Else
        ' Got duplicate sites. We should quit.
        ChangeFtpSiteStatus = intResult
        Exit Function
    End If
    
    For Each strSiteName in aSites
        ' Stop and delete the ftp site
        Set FtpServerObj = providerObj.Get("IIsFtpServer='" & strSiteName & "'")
        If (Err.Number <> 0) Then
            oCmdLib.vbPrintf L_SiteGet_ErrorMessage, Array(strSiteName)
            oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
            DeleteFtpSite = Err.Number
            Exit Function
        End If
        
        FtpServerObj.Stop
        If (Err.Number <> 0) Then
            oCmdLib.vbPrintf L_Stop_ErrorMessage, Array(strSiteName)
            oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
            DeleteFtpSite = Err.Number
            Exit Function
        End If
        
        FtpServerObj.Delete_
        If (Err.Number <> 0) Then
            oCmdLib.vbPrintf L_SiteDel_ErrorMessage, Array(strSiteName)
            oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
            DeleteFtpSite = Err.Number
            Exit Function
        End If
        
        oCmdLib.vbPrintf L_HasBeen_Message, Array(strSiteName, UCase(SiteStatus(8)))
    Next

    DeleteFtpSite = ERR_OK
End Function


'''''''''''''''''''''''''''
' GetADProp
'''''''''''''''''''''''''''
Function GetADProp(strServer, strUser, strPassword, aArgs)
    Dim objLocator
    Dim objService
    Dim collObj, userObj
    
    On Error Resume Next

    Set objLocator = CreateObject("WbemScripting.SWbemLocator")
    ' Set the impersonation level
    objLocator.Security_.ImpersonationLevel = 3

    If strUser <> "" And strPassword <> "" Then
        Set objService = objLocator.ConnectServer(strServer, "root\directory\LDAP", strUser, strPassword)
    Else
        Set objService = objLocator.ConnectServer(strServer, "root\directory\LDAP")
    End If
            
    If Err.Number Then
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        GetADProp = Err.Number
        Exit Function
    End If

    ' Set the impersonation level
    objService.Security_.ImpersonationLevel = 3

    Set collObj = objService.ExecQuery("select * from ds_user where DS_sAMAccountName='" & aArgs(0) & "'")
	If Err.Number Then
		oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
		GetADProp = Err.Number
	Else
		If collObj.Count = 0 Then
			oCmdLib.vbPrintf L_ADUserNotFound_ErrorMessage, Array(aArgs(0))
			' Returns "element not found" error
			GetADProp = &H80070490
		Else
		    oCmdLib.vbPrintf L_GetAD_Message, Array(aArgs(1), aArgs(0))
		
		    For Each userObj in collObj
		        If UCase(aArgs(1)) = "FTPDIR" Then
		            WScript.Echo userObj.DS_msIIS_FTPDir
		        ElseIf UCase(aArgs(1)) = "FTPROOT" Then
		            WScript.Echo userObj.DS_msIIS_FTPRoot
		        Else
		            oCmdLib.vbPrintf L_InvalidArg_ErrorMessage, Array(aArgs(1))
		            GetADProp = ERR_GENERAL_FAILURE
		            Exit Function
		        End If
		    Next

		    GetADProp = ERR_OK
		End If
	End If
End Function


'''''''''''''''''''''''''''
' SetADProp
'''''''''''''''''''''''''''
Function SetADProp(strServer, strUser, strPassword, aArgs)
    Dim objLocator
    Dim objService
    Dim collObj, userObj
    Dim octx
    Dim propName

    On Error Resume Next

    Set objLocator = CreateObject("WbemScripting.SWbemLocator")
    ' Set the impersonation level
    objLocator.Security_.ImpersonationLevel = 3

    If strUser <> "" And strPassword <> "" Then
        Set objService = objLocator.ConnectServer(strServer, "root\directory\LDAP", strUser, strPassword)
    Else
        Set objService = objLocator.ConnectServer(strServer, "root\directory\LDAP")
    End If
            
    If Err.Number Then
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        SetADProp = Err.Number
        Exit Function
    End If

    ' Set the impersonation level
    objService.Security_.ImpersonationLevel = 3

    Set collObj = objService.ExecQuery("select * from ds_user where DS_sAMAccountName='" & aArgs(0) & "'")
	If Err.Number Then
		oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
		SetADProp = Err.Number
	Else
		If collObj.Count = 0 Then
			oCmdLib.vbPrintf L_ADUserNotFound_ErrorMessage, Array(aArgs(0))
			' Returns "element not found" error
			SetADProp = &H80070490
		Else
		    Set octx = CreateObject("WbemScripting.SWbemNamedValueSet")
		    octx.Add "__PUT_EXT_PROPERTIES", Array("DS_msIIS_FTPDir","DS_msIIS_FTPRoot")
		    octx.Add "__PUT_EXTENSIONS", True
		    octx.Add "__PUT_EXT_CLIENT_REQUEST", True
		
		    For Each userObj in collObj
		        If UCase(aArgs(1)) = "FTPROOT" Then
			        userObj.DS_msIIS_FTPRoot = aArgs(2)
		        Elseif UCase(aArgs(1)) = "FTPDIR" Then
			        userObj.DS_msIIS_FTPDir  = aArgs(2)
		        Else
		            oCmdLib.vbPrintf L_InvalidArg_ErrorMessage, Array(aArgs(1))
		            SetADProp = ERR_GENERAL_FAILURE
		            Exit Function
		        End If
		
			    userObj.Put_ 1, octx
			    If Err.Number Then
					oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
					SetADProp = Err.Number
					Exit Function
			    End If
		    Next
		
		    oCmdLib.vbPrintf L_SetAD_Message, Array(aArgs(1), aArgs(0), aArgs(2))
		
		    SetADProp = ERR_OK
		End If
	End If
End Function


'''''''''''''''''''''''''''
' CreateFtpSite
'''''''''''''''''''''''''''
Function CreateFtpSite(strRoot, strName, strPort, strIP, bDontStart, strISO, strADDomain, strADAdmin, strADPass)
    Dim strSitePath
    Dim strSiteObjPath
    Dim Bindings
    Dim objPath, serviceObj
    Dim serverObj, vdirObj, settingObj
    Dim strStatus
    Dim providerObj
    
    On Error Resume Next
    
    ' Default port
    If (strPort = "") Then strPort = "21"

    ' Verify port number
    If Not oScriptHelper.IsValidPortNumber(strPort) Then
        WScript.Echo L_InvalidPort_ErrorMessage
        CreateFtpSite = ERR_GENERAL_FAILURE
        Exit Function
    End If
    
    ' Verify IP Address
    If strIP <> "" Then
        If Not oScriptHelper.IsValidIPAddress(strIP) Then
            WScript.Echo L_InvalidIP_ErrorMessage
            WScript.Echo L_InvalidIP2_ErrorMessage
            CreateFtpSite = ERR_GENERAL_FAILURE
            Exit Function
        End If
    End If
    
    ' Create physical directory
    If strRoot <> "" Then
        oScriptHelper.CreateFSDir strRoot
        If Err.Number Then
            Select Case Err.Number
                Case &H8007000C
                    WScript.Echo L_DirFormat_ErrorMessage
                    WScript.Echo L_DirFormat2_ErrorMessage
                    WScript.Echo L_SeeCreateHelp_Message
                    CreateFtpSite = Err.Number
                    Exit Function
            
                Case &H8007000F
                    WScript.Echo L_MapDrive_ErrorMessage
                    CreateFtpSite = Err.Number
                    Exit Function
    
                Case Else
                    WScript.Echo L_CannotCreateDir_ErrorMessage
                    oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
                    CreateFtpSite = Err.Number
                    Exit Function
            End Select
        End If
    End If

    ' Time to connect to the IIS namespace
    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        CreateFtpSite = Err.Number
        Exit Function
    End If

    Set providerObj = oScriptHelper.ProviderObj
    
    ' Build binding object
    Bindings = Array(0)
    Set Bindings(0) = providerObj.get("ServerBinding").SpawnInstance_()
    Bindings(0).IP = strIP
    Bindings(0).Port = strPort

    Set serviceObj = providerObj.Get("IIsFtpService='MSFTPSVC'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Admin2_ErrorMessage

            Case Else
                WScript.Echo Err.Description
        End Select
        
        CreateFtpSite = Err.Number
        Exit Function
    End If

    strSiteObjPath = serviceObj.CreateNewSite(strName, Bindings, strRoot)
    If Err Then
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        CreateWebSite = Err.Number
        Exit Function        
    End If
    
    ' Parse site ID out of WMI object path
    Set objPath = CreateObject("WbemScripting.SWbemObjectPath")
    objPath.Path = strSiteObjPath
    strSitePath = objPath.Keys.Item("")

    ' Set ftp virtual directory properties
    Set vdirObj = providerObj.Get("IIsFtpVirtualDirSetting='" & strSitePath & "/ROOT'")
    vdirObj.AccessFlags = 1 ' read
    If UCase(strISO) = "AD" Then
        vdirObj.AccessFlags = 32769 ' read, AccessNoPhysicalDir
    End If
    vdirObj.Put_()
    If Err Then
        WScript.Echo L_VDirPut_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        providerObj.Delete(strSiteObjPath)
        CreateWebSite = Err.Number
        Exit Function        
    End If

    ' Site is stopped - CreateNewSite stops it by default
    Set serverObj =  providerObj.Get("IIsFtpServer='" & strSitePath & "'")
    Set settingObj = providerObj.Get("IIsFtpServerSetting='" & strSitePath & "'")

    ' set UserIsolationMode
    If strISO <> "" Then
        If UCase(strISO) = "LOCAL" Then
            settingObj.UserIsolationMode = 1
            settingObj.Put_()
        End If

        If UCase(strISO) = "AD" Then
            settingObj.UserIsolationMode = 2
            settingObj.DefaultLogonDomain = strADDomain
            settingObj.ADConnectionsUserName = strADAdmin
            settingObj.ADConnectionsPassword = strADPass
            settingObj.AllowAnonymous = False
            settingObj.Put_()
        End If

    End If

    ' Should we start the site?
    If Not bDontStart Then
        serverObj.Start
        ' If we cannot start the server, check for error stating the port is already in use
        If Err.Number = &H80070034 Or Err.Number = &H80070020 Or Err.Number = &H80070057 Then
            strStatus = UCase(SiteStatus(4)) & " " & L_BindingConflict_ErrorMessage
        Else
            strStatus = UCase(SiteStatus(2))
        End If
    Else
        strStatus = UCase(SiteStatus(4))
    End If

    If (strServer = ".") Then 
        strServer = oScriptHelper.GetEnvironmentVar("%COMPUTERNAME%")
    End If

    If (strIP = "")  Then strIP  = L_AllUnassigned_Text
    If (strISO = "") Then strISO = L_NoISO_Text

    ' Post summary
    WScript.Echo L_Server_Text & Space(14 - Len(L_Server_Text)) & "= " & UCase(strServer)
    WScript.Echo L_SiteName_Text & Space(14 - Len(L_SiteName_Text)) & "= " & strName
    WScript.Echo L_MetabasePath_Message & Space(14 - Len(L_MetabasePath_Message)) & "= " & strSitePath
    WScript.Echo L_IP_Text & Space(14 - Len(L_IP_Text)) & "= " & strIP
    WScript.Echo L_Port_Text & Space(14 - Len(L_Port_Text)) & "= " & strPort
    WScript.Echo L_Root_Text & Space(14 - Len(L_Root_Text)) & "= " & strRoot
    WScript.Echo L_ISO_Text & Space(14 - Len(L_ISO_Text)) & "= " & strISO
    WScript.Echo L_Status_Text& Space(14 - Len(L_Status_Text)) & "= " & strStatus
    
    CreateFtpSite = intResult
End Function


'''''''''''''''''''''''''''
' QueryFtpSite
'''''''''''''''''''''''''''
Function QueryFtpSite(aArgs)
    Dim Servers, Server, strQuery
    Dim ServerObj, ServiceObj
    Dim i, intResult, firstLen
    Dim bindings, binding
    Dim line, strIP, strPort, strState
    Dim providerObj
    Dim bFirstIteration
    
    On Error Resume Next

    oScriptHelper.WMIConnect
    If Err.Number Then
        WScript.Echo L_WMIConnect_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        QueryFtpSiteStatus = Err.Number
        Exit Function
    End If

    Set providerObj = oScriptHelper.ProviderObj
    intResult = 0

    ' Quick check to see if we have permission
    Set ServiceObj = providerObj.Get("IIsFtpService='MSFTPSVC'")
    If Err.Number Then
        Select Case Err.Number
            Case &H80070005
                WScript.Echo L_Admin_ErrorMessage
                WScript.Echo L_Admin2_ErrorMessage

            Case Else
                WScript.Echo Err.Description
        End Select
        
        QueryFtpSite = Err.Number
        Exit Function
    End If

    If (UBound(aArgs) = -1) Then
        strQuery = "select Name, ServerComment, ServerBindings from IIsFtpServerSetting"
    Else
        strQuery = "select Name, ServerComment, ServerBindings from IIsFtpServerSetting where "
        For i = LBound(aArgs) to UBound(aArgs)
            strQuery = strQuery & "(Name='" & aArgs(i) & "' or ServerComment='" & aArgs(i) & "')"
            If (i <> UBound(aArgs)) Then
                strQuery = strQuery & " or "
            End If
        Next
    End If
    
    ' Semi-sync query. (flags = ForwardOnly Or ReturnImediately = &H30)
    Set Servers = providerObj.ExecQuery(strQuery, , &H30)
    If (Err.Number <> 0) Then
        WScript.Echo L_Query_ErrorMessage
        oCmdLib.vbPrintf L_Error_ErrorMessage, Array(Hex(Err.Number), Err.Description)
        WScript.Quit(Err.Number)
    End If

    bFirstIteration = True
    For Each Server in Servers
        bindings = Server.ServerBindings

        If bFirstIteration Then
            WScript.Echo L_SiteName_Text & " (" & L_MetabasePath_Message & ")" & _
                Space(40 - Len(L_SiteName_Text & L_MetabasePath_Message) + 3) & _
                L_Status_Text & Space(4) & L_IP_Text & Space(14) & L_Port_Text
            WScript.Echo "=============================================================================="
        End If
        
        ' Get server status from the element instance
        Set ServerObj = providerObj.Get("IIsFtpServer='" & Server.Name & "'")
        strState = UCase(SiteStatus(ServerObj.ServerState))
        
        If (IsArray(bindings)) Then
            For i = LBound(bindings) to UBound(bindings)
                If (bindings(i).IP = "") Then
                    strIP = L_All_Text
                Else
                    strIP = bindings(i)
                End If
    
                strPort = bindings(i).Port

                ' If this is the first binding list, print server comment and server name		
                If (i = LBound(bindings)) Then

                    firstLen = 40 - Len(Server.ServerComment & Server.Name) + 3

                    If (firstLen < 1) Then
                        firstLen = 1
                    End If

                    line = Server.ServerComment & " (" & Server.Name & ")" & _
                        Space(firstLen) & strState & _
                        Space(10 - Len(strState)) & strIP & Space(16 - Len(strIP)) & strPort
                Else
                    line = Space(56) & strIP & Space(16 - Len(strIP)) & strPort
                End If

                WScript.Echo line
            Next
        End If
        
        bFirstIteration = False
    Next
    
    If bFirstIteration Then
        WScript.Echo L_SitesNotFound_ErrorMessage
    End If
        
End Function
